/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.ConfigParam;
import de.poiu.coat.c14n.KeyC14n;
import de.poiu.coat.example.AppConfig;
import de.poiu.coat.example.AppConfigParam;
import de.poiu.coat.example.ImmutableMqttConfig;
import de.poiu.coat.example.MqttConfig;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class ImmutableAppConfig
extends CoatConfig
implements AppConfig {
    private static final System.Logger LOGGER = System.getLogger(ImmutableAppConfig.class.getName());
    private final ImmutableMqttConfig mqtt;

    private ImmutableAppConfig(Map<String, String> props) {
        super((ConfigParam[])AppConfigParam.values());
        this.mqtt = ImmutableMqttConfig.from(ImmutableAppConfig.filterByAndStripPrefix(props, (String)"mqtt."));
        super.registerEmbeddedConfig("mqtt.", (CoatConfig)this.mqtt, false);
        this.add(props);
    }

    public static ImmutableAppConfig from(Map<String, String> props) {
        return new ImmutableAppConfig(props);
    }

    public static ImmutableAppConfig from(File file) throws IOException {
        return new ImmutableAppConfig(ImmutableAppConfig.toMap((File)file));
    }

    public static ImmutableAppConfig from(Properties jup) {
        return new ImmutableAppConfig(ImmutableAppConfig.toMap((Properties)jup));
    }

    public static ImmutableAppConfig fromEnvVars() {
        return ImmutableAppConfig.builder().addEnvVars().build();
    }

    @Override
    public String getName() {
        return (String)super.get((ConfigParam)AppConfigParam.GET_NAME);
    }

    @Override
    public Optional<String> getDescription() {
        return super.getOptional((ConfigParam)AppConfigParam.GET_DESCRIPTION);
    }

    @Override
    public InetAddress getListenAddress() {
        return (InetAddress)super.getOrDefault((ConfigParam)AppConfigParam.GET_LISTEN_ADDRESS);
    }

    @Override
    public int getListenPort() {
        return super.getIntOrDefault((ConfigParam)AppConfigParam.GET_LISTEN_PORT);
    }

    @Override
    public MqttConfig mqtt() {
        return this.mqtt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAppConfig other = (ImmutableAppConfig)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.getListenAddress(), other.getListenAddress())) {
            return false;
        }
        if (!Objects.equals(this.getListenPort(), other.getListenPort())) {
            return false;
        }
        return Objects.equals(this.mqtt(), other.mqtt());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getDescription(), this.getListenAddress(), this.getListenPort(), this.mqtt());
    }

    public static void writeExampleConfig(Writer writer) throws IOException {
        writer.append("## A shorthand name for this application. \napplication_name = \n\n## A short description of the purpose of this application. \n# description = \n\n## The interfaces to listen on for incoming connections. \n# listen_address = 0.0.0.0\n\n## The port to listen on for incoming connections. \n# listen_port = 8080\n\n## The clientId to send to the MQTT broker. \n# mqtt.client_id = \n\n## The address(es) of the MQTT broker. \nmqtt.broker_addresses = \n\n## The port to communicate with the MQTT broker. \n# mqtt.port = 1883\n\n## The username to connect to the MQTT broker. \n# mqtt.username = \n\n## The password to connect to the MQTT broker. \n# mqtt.password = \n\n");
        writer.flush();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> props = new HashMap<String, String>();

        public Builder add(Map<String, String> map) {
            this.props.putAll(map);
            return this;
        }

        public Builder add(File file) throws IOException {
            this.props.putAll(ImmutableAppConfig.toMap((File)file));
            return this;
        }

        public Builder add(Properties jup) {
            this.props.putAll(ImmutableAppConfig.toMap((Properties)jup));
            return this;
        }

        public Builder addEnvVars() {
            Map<String, String> envVars = System.getenv();
            String[] configKeys = new String[]{"application_name", "description", "listen_address", "listen_port", "mqtt.client_id", "mqtt.broker_addresses", "mqtt.port", "mqtt.username", "mqtt.password"};
            for (String envVar : envVars.keySet()) {
                for (String configKey : configKeys) {
                    if (!envVar.toUpperCase().equals(KeyC14n.c14n((String)configKey))) continue;
                    LOGGER.log(System.Logger.Level.INFO, "Using environment variable {0} as config key {1}", envVar, configKey);
                    this.props.put(configKey, envVars.get(envVar));
                }
            }
            return this;
        }

        public ImmutableAppConfig build() {
            return new ImmutableAppConfig(this.props);
        }
    }
}

