/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.example.AppConfig;
import de.poiu.coat.example.ImmutableAppConfig;
import de.poiu.coat.example.MqttConfig;
import de.poiu.coat.example.mqtt.DummyMqttClient;
import de.poiu.coat.validation.ConfigValidationException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.Set;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class ExampleApp {
    public static void main(String[] args) throws IOException {
        Properties props = new Properties();
        props.load(ExampleApp.class.getResourceAsStream("/app.properties"));
        ImmutableAppConfig appConfig = ImmutableAppConfig.from(props);
        System.out.println("Configuration:\n" + appConfig.toString());
        try {
            appConfig.validate();
        }
        catch (ConfigValidationException ex) {
            System.err.println("Error in config:\n" + ex.getValidationResult().toString());
            System.exit(1);
        }
        Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)appConfig, new Class[0]);
        if (!violations.isEmpty()) {
            System.err.println("Error in config:");
            for (ConstraintViolation violation : violations) {
                System.err.println(String.valueOf(violation.getPropertyPath()) + " \u2192 " + violation.getMessage());
            }
            System.exit(1);
        }
        ExampleApp.startApplication(appConfig);
    }

    private static void startApplication(AppConfig appConfig) {
        ExampleApp.startMqttClient(appConfig.mqtt());
        System.out.println("Starting server for " + appConfig.getName() + " \u2026");
        appConfig.getDescription().ifPresent(System.out::println);
        try {
            ServerSocket serverSocket = new ServerSocket(appConfig.getListenPort(), 1, appConfig.getListenAddress());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        System.out.println("\nDemonstration finished\u2026");
    }

    private static void startMqttClient(MqttConfig mqtt) {
        DummyMqttClient mqttClient = new DummyMqttClient(mqtt.getBrokerAddresses(), mqtt.getPort());
        mqtt.getClientId().ifPresent(mqttClient::setClientId);
        mqtt.username().ifPresent(mqttClient::setUsername);
        mqtt.password().ifPresent(mqttClient::setPassword);
        mqttClient.connect();
    }
}

