/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.annotation.Coat;
import de.poiu.coat.casing.CasingStrategy;
import de.poiu.coat.example.MqttConfig;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.net.InetAddress;
import java.util.Optional;

@Coat.Config(casing=CasingStrategy.SNAKE_CASE)
public interface AppConfig {
    @Coat.Param(key="application_name")
    public String getName();

    public Optional<String> getDescription();

    @Coat.Param(defaultValue="0.0.0.0")
    public InetAddress getListenAddress();

    @Min(value=1024L)
    @Max(value=49151L)
    @Coat.Param(defaultValue="8080")
    public @Min(value=1024L) @Max(value=49151L) int getListenPort();

    @Coat.Embedded
    public MqttConfig mqtt();
}

