package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.c14n.KeyC14n;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.System;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.processing.Generated;

@Generated(
    value = "de.poiu.coat.processor.codegeneration.CodeGenerator",
    date = "2024-03-07T23:24:03.188890378+01:00"
)
public class ImmutableMqttConfig extends CoatConfig implements MqttConfig {
  private static final System.Logger LOGGER = System.getLogger(de.poiu.coat.example.ImmutableMqttConfig.class.getName());

  private ImmutableMqttConfig(final Map<String, String> props) {
    super(MqttConfigParam.values());

    this.add(props);
  }

  /**
   * Create a new ImmutableMqttConfig from the given config entries.
   *
   * @param props the config entries
   * @return the ImmutableMqttConfig created with the given entries
   */
  public static ImmutableMqttConfig from(final Map<String, String> props) {
    return new ImmutableMqttConfig(props);
  }

  /**
   * Create a new ImmutableMqttConfig from the given config file.
   *
   * @param file the config file to read
   * @return the ImmutableMqttConfig created with the entries from the given file
   * @throws IOException if reading the given file failed
   */
  public static ImmutableMqttConfig from(final File file) throws IOException {
    return new ImmutableMqttConfig(toMap(file));
  }

  /**
   * Create a new ImmutableMqttConfig from the given config entries.
   *
   * @param jup the config entries
   * @return the ImmutableMqttConfig created with the given entries
   */
  public static ImmutableMqttConfig from(final Properties jup) {
    return new ImmutableMqttConfig(toMap(jup));
  }

  /**
   * Create a new ImmutableMqttConfig from the current environment variables.
   * <p>
   * Since the allowed characters for environment variables are much more restricted than Coat config keys,
   * a relaxed mapping is applied.
   * <p>Dots and hyphens are treated as underscores. Also uppercase
   * characters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).
   * Comparison between the environment variables and the config keys is done case insensitively.<p>
   * For example the environment variable
   * <code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.
   *
   * @return the ImmutableMqttConfig created with the entries in the current environment variables
   */
  public static ImmutableMqttConfig fromEnvVars() {
    return builder().addEnvVars().build();
  }

  /**
   * The clientId to send to the MQTT broker. 
   */
  @Override
  public Optional<String> getClientId() {
    return super.getOptional(MqttConfigParam.GET_CLIENT_ID);
  }

  /**
   * The address(es) of the MQTT broker. 
   */
  @Override
  public InetAddress[] getBrokerAddresses() {
    return super.getArray(MqttConfigParam.GET_BROKER_ADDRESSES);
  }

  /**
   * The port to communicate with the MQTT broker. 
   */
  @Override
  public int getPort() {
    return super.getIntOrDefault(MqttConfigParam.GET_PORT);
  }

  /**
   * The username to connect to the MQTT broker. 
   */
  @Override
  public Optional<String> username() {
    return super.getOptional(MqttConfigParam.USERNAME);
  }

  /**
   * The password to connect to the MQTT broker. 
   */
  @Override
  public Optional<String> password() {
    return super.getOptional(MqttConfigParam.PASSWORD);
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj) {
      return true;
    }

    if (obj == null) {
      return false;
    }

    if (this.getClass() != obj.getClass()) {
      return false;
    }

    final ImmutableMqttConfig other = (ImmutableMqttConfig) obj;

    if (!Objects.equals(this.getClientId(), other.getClientId())) {
      return false;
    }

    if (!Objects.equals(this.getBrokerAddresses(), other.getBrokerAddresses())) {
      return false;
    }

    if (!Objects.equals(this.getPort(), other.getPort())) {
      return false;
    }

    if (!Objects.equals(this.username(), other.username())) {
      return false;
    }

    if (!Objects.equals(this.password(), other.password())) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(
        getClientId(),
        getBrokerAddresses(),
        getPort(),
        username(),
        password());
  }

  /**
   * Write an example config file to the given Writer.
   *
   * @param writer the Writer to write to
   * @throws IOException if writing the example config file fails
   */
  public static void writeExampleConfig(final Writer writer) throws IOException {
    writer.append("## The clientId to send to the MQTT broker. \n"
            + "# client_id = \n"
            + "\n"
            + "## The address(es) of the MQTT broker. \n"
            + "broker_addresses = \n"
            + "\n"
            + "## The port to communicate with the MQTT broker. \n"
            + "# port = 1883\n"
            + "\n"
            + "## The username to connect to the MQTT broker. \n"
            + "# username = \n"
            + "\n"
            + "## The password to connect to the MQTT broker. \n"
            + "# password = \n"
            + "\n");
    writer.flush();
  }

  /**
   * Create a builder for {@link ImmutableMqttConfig} instances.
   * <p>
   * Call the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config
   * sources (and the order in which they are applied), then call {@link Builder#build()} to create the
   * ImmutableMqttConfig
   *
   * @return an new ImmutableMqttConfig builder
   */
  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder class for creating new {@link ImmutableMqttConfig} instances.
   * <p>
   * Call the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config
   * sources (and the order in which they are applied), then call {@link Builder#build()} to create the
   * ImmutableMqttConfig
   */
  public static class Builder {
    private final Map<String, String> props = new HashMap<>();

    /**
     * Add the config entries from the given Map to the built ImmutableMqttConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param map the config entries to add
     * @return this Builder
     */
    public Builder add(final Map<String, String> map) {
      this.props.putAll(map);
      return this;
    }

    /**
     * Add the config entries from the given file to the built ImmutableMqttConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param file the file with the config entries to add
     * @return this Builder
     * @throws java.io.IOException if reading the config file failed
     */
    public Builder add(final File file) throws IOException {
      this.props.putAll(toMap(file));
      return this;
    }

    /**
     * Add the config entries from the given Properties to the built ImmutableMqttConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param jup the config entries to add
     * @return this Builder
     */
    public Builder add(final Properties jup) {
      this.props.putAll(toMap(jup));
      return this;
    }

    /**
     * Add the config entries from the current environment variables to the built ImmutableMqttConfig.
     * Already existing config entries with the same keys will be overwritten.
     * <p>
     * Since the allowed characters for environment variables are much more restricted than Coat config keys,
     * a relaxed mapping is applied.
     * <p>Dots and hyphens are treated as underscores. Also uppercase
     * characters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).
     * Comparison between the environment variables and the config keys is done case insensitively.<p>
     * For example the environment variable
     * <code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.
     * @return this Builder
     */
    public Builder addEnvVars() {
      final Map<String, String> envVars= System.getenv();
      final String[] configKeys= {
          "client_id",
          "broker_addresses",
          "port",
          "username",
          "password"
          };

      for (final String envVar : envVars.keySet()) {
        for (final String configKey : configKeys) {
          if (envVar.toUpperCase().equals(KeyC14n.c14n(configKey))) {
            LOGGER.log(System.Logger.Level.INFO, "Using environment variable {0} as config key {1}", new Object[]{envVar, configKey});
            this.props.put(configKey, envVars.get(envVar));
          }
        }
      }

      return this;
    }

    /**
     * Build a new {@link ImmutableMqttConfig} with the config keys from this Builder.
     *
     * @return a new ImmutableMqttConfig
     */
    public ImmutableMqttConfig build() {
      return new ImmutableMqttConfig(this.props);
    }
  }
}
