package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.c14n.KeyC14n;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.System;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.processing.Generated;

@Generated(
    value = "de.poiu.coat.processor.codegeneration.CodeGenerator",
    date = "2024-03-07T23:24:03.20198587+01:00"
)
public class ImmutableAppConfig extends CoatConfig implements AppConfig {
  private static final System.Logger LOGGER = System.getLogger(de.poiu.coat.example.ImmutableAppConfig.class.getName());

  private final ImmutableMqttConfig mqtt;

  private ImmutableAppConfig(final Map<String, String> props) {
    super(AppConfigParam.values());

    this.mqtt= ImmutableMqttConfig.from(
        filterByAndStripPrefix(props, "mqtt."));
    super.registerEmbeddedConfig("mqtt.", this.mqtt, false);

    this.add(props);
  }

  /**
   * Create a new ImmutableAppConfig from the given config entries.
   *
   * @param props the config entries
   * @return the ImmutableAppConfig created with the given entries
   */
  public static ImmutableAppConfig from(final Map<String, String> props) {
    return new ImmutableAppConfig(props);
  }

  /**
   * Create a new ImmutableAppConfig from the given config file.
   *
   * @param file the config file to read
   * @return the ImmutableAppConfig created with the entries from the given file
   * @throws IOException if reading the given file failed
   */
  public static ImmutableAppConfig from(final File file) throws IOException {
    return new ImmutableAppConfig(toMap(file));
  }

  /**
   * Create a new ImmutableAppConfig from the given config entries.
   *
   * @param jup the config entries
   * @return the ImmutableAppConfig created with the given entries
   */
  public static ImmutableAppConfig from(final Properties jup) {
    return new ImmutableAppConfig(toMap(jup));
  }

  /**
   * Create a new ImmutableAppConfig from the current environment variables.
   * <p>
   * Since the allowed characters for environment variables are much more restricted than Coat config keys,
   * a relaxed mapping is applied.
   * <p>Dots and hyphens are treated as underscores. Also uppercase
   * characters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).
   * Comparison between the environment variables and the config keys is done case insensitively.<p>
   * For example the environment variable
   * <code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.
   *
   * @return the ImmutableAppConfig created with the entries in the current environment variables
   */
  public static ImmutableAppConfig fromEnvVars() {
    return builder().addEnvVars().build();
  }

  /**
   * A shorthand name for this application. 
   */
  @Override
  public String getName() {
    return super.get(AppConfigParam.GET_NAME);
  }

  /**
   * A short description of the purpose of this application. 
   */
  @Override
  public Optional<String> getDescription() {
    return super.getOptional(AppConfigParam.GET_DESCRIPTION);
  }

  /**
   * The interfaces to listen on for incoming connections. 
   */
  @Override
  public InetAddress getListenAddress() {
    return super.getOrDefault(AppConfigParam.GET_LISTEN_ADDRESS);
  }

  /**
   * The port to listen on for incoming connections. 
   */
  @Override
  public int getListenPort() {
    return super.getIntOrDefault(AppConfigParam.GET_LISTEN_PORT);
  }

  /**
   * The configuration for the MQTT connection 
   */
  @Override
  public MqttConfig mqtt() {
    return this.mqtt;
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj) {
      return true;
    }

    if (obj == null) {
      return false;
    }

    if (this.getClass() != obj.getClass()) {
      return false;
    }

    final ImmutableAppConfig other = (ImmutableAppConfig) obj;

    if (!Objects.equals(this.getName(), other.getName())) {
      return false;
    }

    if (!Objects.equals(this.getDescription(), other.getDescription())) {
      return false;
    }

    if (!Objects.equals(this.getListenAddress(), other.getListenAddress())) {
      return false;
    }

    if (!Objects.equals(this.getListenPort(), other.getListenPort())) {
      return false;
    }

    if (!Objects.equals(this.mqtt(), other.mqtt())) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(
        getName(),
        getDescription(),
        getListenAddress(),
        getListenPort(),
        mqtt());
  }

  /**
   * Write an example config file to the given Writer.
   *
   * @param writer the Writer to write to
   * @throws IOException if writing the example config file fails
   */
  public static void writeExampleConfig(final Writer writer) throws IOException {
    writer.append("## A shorthand name for this application. \n"
            + "application_name = \n"
            + "\n"
            + "## A short description of the purpose of this application. \n"
            + "# description = \n"
            + "\n"
            + "## The interfaces to listen on for incoming connections. \n"
            + "# listen_address = 0.0.0.0\n"
            + "\n"
            + "## The port to listen on for incoming connections. \n"
            + "# listen_port = 8080\n"
            + "\n"
            + "## The clientId to send to the MQTT broker. \n"
            + "# mqtt.client_id = \n"
            + "\n"
            + "## The address(es) of the MQTT broker. \n"
            + "mqtt.broker_addresses = \n"
            + "\n"
            + "## The port to communicate with the MQTT broker. \n"
            + "# mqtt.port = 1883\n"
            + "\n"
            + "## The username to connect to the MQTT broker. \n"
            + "# mqtt.username = \n"
            + "\n"
            + "## The password to connect to the MQTT broker. \n"
            + "# mqtt.password = \n"
            + "\n");
    writer.flush();
  }

  /**
   * Create a builder for {@link ImmutableAppConfig} instances.
   * <p>
   * Call the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config
   * sources (and the order in which they are applied), then call {@link Builder#build()} to create the
   * ImmutableAppConfig
   *
   * @return an new ImmutableAppConfig builder
   */
  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder class for creating new {@link ImmutableAppConfig} instances.
   * <p>
   * Call the <code>add</code> and/or <code>addEnvVars</code> methods for specifying the config
   * sources (and the order in which they are applied), then call {@link Builder#build()} to create the
   * ImmutableAppConfig
   */
  public static class Builder {
    private final Map<String, String> props = new HashMap<>();

    /**
     * Add the config entries from the given Map to the built ImmutableAppConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param map the config entries to add
     * @return this Builder
     */
    public Builder add(final Map<String, String> map) {
      this.props.putAll(map);
      return this;
    }

    /**
     * Add the config entries from the given file to the built ImmutableAppConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param file the file with the config entries to add
     * @return this Builder
     * @throws java.io.IOException if reading the config file failed
     */
    public Builder add(final File file) throws IOException {
      this.props.putAll(toMap(file));
      return this;
    }

    /**
     * Add the config entries from the given Properties to the built ImmutableAppConfig.
     * Already existing config entries with the same keys will be overwritten.
     *
     * @param jup the config entries to add
     * @return this Builder
     */
    public Builder add(final Properties jup) {
      this.props.putAll(toMap(jup));
      return this;
    }

    /**
     * Add the config entries from the current environment variables to the built ImmutableAppConfig.
     * Already existing config entries with the same keys will be overwritten.
     * <p>
     * Since the allowed characters for environment variables are much more restricted than Coat config keys,
     * a relaxed mapping is applied.
     * <p>Dots and hyphens are treated as underscores. Also uppercase
     * characters in config keys are preceded by an underscore (to convert camelCase to UPPER_CASE).
     * Comparison between the environment variables and the config keys is done case insensitively.<p>
     * For example the environment variable
     * <code>SERVER_MQTT_HOST</code> will match the config key <code>server.mqttHost</code>.
     * @return this Builder
     */
    public Builder addEnvVars() {
      final Map<String, String> envVars= System.getenv();
      final String[] configKeys= {
          "application_name",
          "description",
          "listen_address",
          "listen_port",
          "mqtt.client_id",
          "mqtt.broker_addresses",
          "mqtt.port",
          "mqtt.username",
          "mqtt.password"
          };

      for (final String envVar : envVars.keySet()) {
        for (final String configKey : configKeys) {
          if (envVar.toUpperCase().equals(KeyC14n.c14n(configKey))) {
            LOGGER.log(System.Logger.Level.INFO, "Using environment variable {0} as config key {1}", new Object[]{envVar, configKey});
            this.props.put(configKey, envVars.get(envVar));
          }
        }
      }

      return this;
    }

    /**
     * Build a new {@link ImmutableAppConfig} with the config keys from this Builder.
     *
     * @return a new ImmutableAppConfig
     */
    public ImmutableAppConfig build() {
      return new ImmutableAppConfig(this.props);
    }
  }
}
