package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Generated;

@Generated(
    value = "de.poiu.coat.processor.CoatProcessor",
    date = "2021-05-31T15:08:20.100021+02:00"
)
public class ImmutableMqttConfig extends CoatConfig implements MqttConfig {
  public ImmutableMqttConfig(final File file) throws IOException {
    this(toMap(file));
  }

  public ImmutableMqttConfig(final Properties props) {
    this(toMap(props));
  }

  public ImmutableMqttConfig(final Map<String, String> props) {
    super(props, MqttConfigParam.values());
  }

  /**
   * The clientId to send to the MQTT broker. 
   */
  @Override
  public Optional<String> clientId() {
    return super.getOptional(MqttConfigParam.CLIENT_ID);
  }

  /**
   * The address of the MQTT broker. 
   */
  @Override
  public InetAddress brokerAddress() {
    return super.get(MqttConfigParam.BROKER_ADDRESS);
  }

  /**
   * The port to communicate with the MQTT broker. 
   */
  @Override
  public int port() {
    return super.getIntOrDefault(MqttConfigParam.PORT);
  }

  /**
   * The username to connect to the MQTT broker. 
   */
  @Override
  public Optional<String> username() {
    return super.getOptional(MqttConfigParam.USERNAME);
  }

  /**
   * The password to connect to the MQTT broker. 
   */
  @Override
  public Optional<String> password() {
    return super.getOptional(MqttConfigParam.PASSWORD);
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj) {
      return true;
    }

    if (obj == null) {
      return false;
    }

    if (this.getClass() != obj.getClass()) {
      return false;
    }

    final ImmutableMqttConfig other = (ImmutableMqttConfig) obj;

    if (!Objects.equals(this.clientId(), other.clientId())) {
      return false;
    }

    if (!Objects.equals(this.brokerAddress(), other.brokerAddress())) {
      return false;
    }

    if (!Objects.equals(this.port(), other.port())) {
      return false;
    }

    if (!Objects.equals(this.username(), other.username())) {
      return false;
    }

    if (!Objects.equals(this.password(), other.password())) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(
        clientId(),
        brokerAddress(),
        port(),
        username(),
        password());
  }

  public static void writeExampleConfig(final Writer writer) throws IOException {
    writeExampleConfig(new BufferedWriter(writer));
  }

  public static void writeExampleConfig(final BufferedWriter writer) throws IOException {
    writer.append("## The clientId to send to the MQTT broker. \n"
            + "# client_id = \n"
            + "\n"
            + "## The address of the MQTT broker. \n"
            + "broker_address = \n"
            + "\n"
            + "## The port to communicate with the MQTT broker. \n"
            + "# port = 1883\n"
            + "\n"
            + "## The username to connect to the MQTT broker. \n"
            + "# username = \n"
            + "\n"
            + "## The password to connect to the MQTT broker. \n"
            + "# password = \n"
            + "\n");
    writer.flush();
  }
}
