package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Generated;

@Generated(
    value = "de.poiu.coat.processor.CoatProcessor",
    date = "2021-05-31T15:08:20.056661+02:00"
)
public class ImmutableAppConfig extends CoatConfig implements AppConfig {
  private final ImmutableMqttConfig mqtt;

  public ImmutableAppConfig(final File file) throws IOException {
    this(toMap(file));
  }

  public ImmutableAppConfig(final Properties props) {
    this(toMap(props));
  }

  public ImmutableAppConfig(final Map<String, String> props) {
    super(props, AppConfigParam.values());

    this.mqtt= new ImmutableMqttConfig(
        filterByAndStripPrefix(props, "mqtt."));
    super.registerEmbeddedConfig("mqtt.", this.mqtt, false);
  }

  /**
   * A shorthand name for this application. 
   */
  @Override
  public String name() {
    return super.getString(AppConfigParam.NAME);
  }

  /**
   * A short description of the purpose of this application. 
   */
  @Override
  public Optional<String> description() {
    return super.getOptional(AppConfigParam.DESCRIPTION);
  }

  /**
   * The interfaces to listen on for incoming connections. 
   */
  @Override
  public InetAddress listenAddres() {
    return super.getOrDefault(AppConfigParam.LISTEN_ADDRES);
  }

  /**
   * The port to listen on for incoming connections. 
   */
  @Override
  public int listenPort() {
    return super.getIntOrDefault(AppConfigParam.LISTEN_PORT);
  }

  /**
   * The configuration for the MQTT connection 
   */
  @Override
  public MqttConfig mqtt() {
    return this.mqtt;
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj) {
      return true;
    }

    if (obj == null) {
      return false;
    }

    if (this.getClass() != obj.getClass()) {
      return false;
    }

    final ImmutableAppConfig other = (ImmutableAppConfig) obj;

    if (!Objects.equals(this.name(), other.name())) {
      return false;
    }

    if (!Objects.equals(this.description(), other.description())) {
      return false;
    }

    if (!Objects.equals(this.listenAddres(), other.listenAddres())) {
      return false;
    }

    if (!Objects.equals(this.listenPort(), other.listenPort())) {
      return false;
    }

    if (!Objects.equals(this.mqtt(), other.mqtt())) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return java.util.Objects.hash(
        name(),
        description(),
        listenAddres(),
        listenPort(),
        mqtt());
  }

  public static void writeExampleConfig(final Writer writer) throws IOException {
    writeExampleConfig(new BufferedWriter(writer));
  }

  public static void writeExampleConfig(final BufferedWriter writer) throws IOException {
    writer.append("## A shorthand name for this application. \n"
            + "name = \n"
            + "\n"
            + "## A short description of the purpose of this application. \n"
            + "# description = \n"
            + "\n"
            + "## The interfaces to listen on for incoming connections. \n"
            + "# listen_address = 0.0.0.0\n"
            + "\n"
            + "## The port to listen on for incoming connections. \n"
            + "# listen_port = 8080\n"
            + "\n"
            + "## The clientId to send to the MQTT broker. \n"
            + "# mqtt.client_id = \n"
            + "\n"
            + "## The address of the MQTT broker. \n"
            + "mqtt.broker_address = \n"
            + "\n"
            + "## The port to communicate with the MQTT broker. \n"
            + "# mqtt.port = 1883\n"
            + "\n"
            + "## The username to connect to the MQTT broker. \n"
            + "# mqtt.username = \n"
            + "\n"
            + "## The password to connect to the MQTT broker. \n"
            + "# mqtt.password = \n"
            + "\n");
    writer.flush();
  }
}
