/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.ConfigParam;
import de.poiu.coat.example.MqttConfig;
import de.poiu.coat.example.MqttConfigParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class ImmutableMqttConfig
extends CoatConfig
implements MqttConfig {
    public ImmutableMqttConfig(File file) throws IOException {
        this(ImmutableMqttConfig.toMap((File)file));
    }

    public ImmutableMqttConfig(Properties props) {
        this(ImmutableMqttConfig.toMap((Properties)props));
    }

    public ImmutableMqttConfig(Map<String, String> props) {
        super(props, (ConfigParam[])MqttConfigParam.values());
    }

    @Override
    public Optional<String> clientId() {
        return super.getOptional((ConfigParam)MqttConfigParam.CLIENT_ID);
    }

    @Override
    public InetAddress brokerAddress() {
        return (InetAddress)super.get((ConfigParam)MqttConfigParam.BROKER_ADDRESS);
    }

    @Override
    public int port() {
        return super.getIntOrDefault((ConfigParam)MqttConfigParam.PORT);
    }

    @Override
    public Optional<String> username() {
        return super.getOptional((ConfigParam)MqttConfigParam.USERNAME);
    }

    @Override
    public Optional<String> password() {
        return super.getOptional((ConfigParam)MqttConfigParam.PASSWORD);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableMqttConfig other = (ImmutableMqttConfig)obj;
        if (!Objects.equals(this.clientId(), other.clientId())) {
            return false;
        }
        if (!Objects.equals(this.brokerAddress(), other.brokerAddress())) {
            return false;
        }
        if (!Objects.equals(this.port(), other.port())) {
            return false;
        }
        if (!Objects.equals(this.username(), other.username())) {
            return false;
        }
        return Objects.equals(this.password(), other.password());
    }

    public int hashCode() {
        return Objects.hash(this.clientId(), this.brokerAddress(), this.port(), this.username(), this.password());
    }

    public static void writeExampleConfig(Writer writer) throws IOException {
        ImmutableMqttConfig.writeExampleConfig(new BufferedWriter(writer));
    }

    public static void writeExampleConfig(BufferedWriter writer) throws IOException {
        writer.append("## The clientId to send to the MQTT broker. \n# client_id = \n\n## The address of the MQTT broker. \nbroker_address = \n\n## The port to communicate with the MQTT broker. \n# port = 1883\n\n## The username to connect to the MQTT broker. \n# username = \n\n## The password to connect to the MQTT broker. \n# password = \n\n");
        writer.flush();
    }
}

