/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import de.poiu.coat.ConfigParam;
import de.poiu.coat.example.AppConfig;
import de.poiu.coat.example.AppConfigParam;
import de.poiu.coat.example.ImmutableMqttConfig;
import de.poiu.coat.example.MqttConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class ImmutableAppConfig
extends CoatConfig
implements AppConfig {
    private final ImmutableMqttConfig mqtt;

    public ImmutableAppConfig(File file) throws IOException {
        this(ImmutableAppConfig.toMap((File)file));
    }

    public ImmutableAppConfig(Properties props) {
        this(ImmutableAppConfig.toMap((Properties)props));
    }

    public ImmutableAppConfig(Map<String, String> props) {
        super(props, (ConfigParam[])AppConfigParam.values());
        this.mqtt = new ImmutableMqttConfig(ImmutableAppConfig.filterByAndStripPrefix(props, (String)"mqtt."));
        super.registerEmbeddedConfig("mqtt.", (CoatConfig)this.mqtt, false);
    }

    @Override
    public String name() {
        return super.getString((ConfigParam)AppConfigParam.NAME);
    }

    @Override
    public Optional<String> description() {
        return super.getOptional((ConfigParam)AppConfigParam.DESCRIPTION);
    }

    @Override
    public InetAddress listenAddres() {
        return (InetAddress)super.getOrDefault((ConfigParam)AppConfigParam.LISTEN_ADDRES);
    }

    @Override
    public int listenPort() {
        return super.getIntOrDefault((ConfigParam)AppConfigParam.LISTEN_PORT);
    }

    @Override
    public MqttConfig mqtt() {
        return this.mqtt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableAppConfig other = (ImmutableAppConfig)obj;
        if (!Objects.equals(this.name(), other.name())) {
            return false;
        }
        if (!Objects.equals(this.description(), other.description())) {
            return false;
        }
        if (!Objects.equals(this.listenAddres(), other.listenAddres())) {
            return false;
        }
        if (!Objects.equals(this.listenPort(), other.listenPort())) {
            return false;
        }
        return Objects.equals(this.mqtt(), other.mqtt());
    }

    public int hashCode() {
        return Objects.hash(this.name(), this.description(), this.listenAddres(), this.listenPort(), this.mqtt());
    }

    public static void writeExampleConfig(Writer writer) throws IOException {
        ImmutableAppConfig.writeExampleConfig(new BufferedWriter(writer));
    }

    public static void writeExampleConfig(BufferedWriter writer) throws IOException {
        writer.append("## A shorthand name for this application. \nname = \n\n## A short description of the purpose of this application. \n# description = \n\n## The interfaces to listen on for incoming connections. \n# listen_address = 0.0.0.0\n\n## The port to listen on for incoming connections. \n# listen_port = 8080\n\n## The clientId to send to the MQTT broker. \n# mqtt.client_id = \n\n## The address of the MQTT broker. \nmqtt.broker_address = \n\n## The port to communicate with the MQTT broker. \n# mqtt.port = 1883\n\n## The username to connect to the MQTT broker. \n# mqtt.username = \n\n## The password to connect to the MQTT broker. \n# mqtt.password = \n\n");
        writer.flush();
    }
}

