/*
 * Decompiled with CFR 0.152.
 */
package de.poiu.coat.example;

import de.poiu.coat.example.ImmutableAppConfig;
import de.poiu.coat.example.MqttConfig;
import de.poiu.coat.example.mqtt.DummyMqttClient;
import de.poiu.coat.validation.ConfigValidationException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;

public class ExampleApp {
    public static void main(String[] args) throws IOException {
        Properties props = new Properties();
        props.load(ExampleApp.class.getResourceAsStream("/app.properties"));
        ImmutableAppConfig appConfig = new ImmutableAppConfig(props);
        System.out.println("Configuration:\n" + appConfig.toString());
        try {
            appConfig.validate();
        }
        catch (ConfigValidationException ex) {
            System.err.println("Error in config:\n" + ex.getValidationResult().toString());
            System.exit(1);
        }
        ExampleApp.startMqttClient(appConfig.mqtt());
        System.out.println("Starting server for " + appConfig.name() + " \u2026");
        appConfig.description().ifPresent(System.out::println);
        try {
            ServerSocket ex = new ServerSocket(appConfig.listenPort(), 1, appConfig.listenAddres());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        System.out.println("\nDemonstration finished\u2026");
    }

    private static void startMqttClient(MqttConfig mqtt) {
        DummyMqttClient mqttClient = new DummyMqttClient(mqtt.brokerAddress(), mqtt.port());
        mqtt.clientId().ifPresent(mqttClient::setClientId);
        mqtt.username().ifPresent(mqttClient::setUsername);
        mqtt.password().ifPresent(mqttClient::setPassword);
        mqttClient.connect();
    }
}

