package de.poiu.coat.example;

import de.poiu.coat.CoatConfig;
import java.io.File;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.annotation.Generated;

@Generated(
    value = "de.poiu.coat.processor.CoatProcessor",
    date = "2021-03-19T16:38:45.150037+01:00"
)
public class ImmutableExampleConfig extends CoatConfig implements ExampleConfig {
  public ImmutableExampleConfig(final File file) throws IOException {
    super(file, ExampleConfigParam.values());
  }

  public ImmutableExampleConfig(final Properties props) {
    super(props, ExampleConfigParam.values());
  }

  public ImmutableExampleConfig(final Map<String, String> props) {
    super(props, ExampleConfigParam.values());
  }

  /**
   *  This is a mandatory string that must be specified in the config file.
   *  <p>
   *  The application will not start without it.
   *
   *  @return the config value for mandatorString
   */
  @Override
  public String mandatoryString() {
    return super.getString(ExampleConfigParam.MANDATORY_STRING);
  }

  /**
   *  An optional int that <em>may</em> be specified, but may also be left off.
   *  <p>
   *  The application can run without it.3
   *
   *  Und hier ist das @mittendrin enthalten.
   *
   *  @return the config value for optionalInt
   */
  @Override
  public OptionalInt optionalInt() {
    return super.getOptionalInt(ExampleConfigParam.OPTIONAL_INT);
  }

  /**
   *  The charset to use. If not specified it defaults to UTF-8.
   *
   *  @return the config value for charsetWithDefault
   */
  @Override
  public Charset charsetWithDefault() {
    return super.getOrDefault(ExampleConfigParam.CHARSET_WITH_DEFAULT);
  }

  /**
   *  An InetAddress that <em>may</em> be specified.
   *  <p>
   *  The value from the config file must conform to the same rules as the InetAddress constructor.
   *  Basically that means that IP addresses or hostnames can be specified.
   *
   *  @return the config value for optionalInetAddress
   */
  @Override
  public Optional<InetAddress> optionalInetAddress() {
    return super.getOptional(ExampleConfigParam.OPTIONAL_INET_ADDRESS);
  }
}
