/*******************************************************************************
 * Copyright (c) 2013, Daniel Murphy
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 	* Redistributions of source code must retain the above copyright notice,
 * 	  this list of conditions and the following disclaimer.
 * 	* Redistributions in binary form must reproduce the above copyright notice,
 * 	  this list of conditions and the following disclaimer in the documentation
 * 	  and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
package de.pirckheimer_gymnasium.jbox2d.testbed.tests;

import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureDef;
import de.pirckheimer_gymnasium.jbox2d.testbed.framework.TestbedTest;

public class DominoTest extends TestbedTest
{
    @Override
    public boolean isSaveLoadEnabled()
    {
        return true;
    }

    public void initTest(boolean argDeserialized)
    {
        if (argDeserialized)
        {
            return;
        }
        { // Floor
            FixtureDef fd = new FixtureDef();
            PolygonShape sd = new PolygonShape();
            sd.setAsBox(50.0f, 10.0f);
            fd.shape = sd;
            BodyDef bd = new BodyDef();
            bd.position = new Vec2(0.0f, -10.0f);
            getWorld().createBody(bd).createFixture(fd);
        }
        { // Platforms
            for (int i = 0; i < 4; i++)
            {
                FixtureDef fd = new FixtureDef();
                PolygonShape sd = new PolygonShape();
                sd.setAsBox(15.0f, 0.125f);
                fd.shape = sd;
                BodyDef bd = new BodyDef();
                bd.position = new Vec2(0.0f, 5f + 5f * i);
                getWorld().createBody(bd).createFixture(fd);
            }
        }
        {
            FixtureDef fd = new FixtureDef();
            PolygonShape sd = new PolygonShape();
            sd.setAsBox(0.125f, 2f);
            fd.shape = sd;
            fd.density = 25.0f;
            BodyDef bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            float friction = .5f;
            int numPerRow = 25;
            for (int i = 0; i < 4; ++i)
            {
                for (int j = 0; j < numPerRow; j++)
                {
                    fd.friction = friction;
                    bd.position = new Vec2(
                            -14.75f + j * (29.5f / (numPerRow - 1)),
                            7.3f + 5f * i);
                    if (i == 2 && j == 0)
                    {
                        bd.angle = -0.1f;
                        bd.position.x += .1f;
                    }
                    else if (i == 3 && j == numPerRow - 1)
                    {
                        bd.angle = .1f;
                        bd.position.x -= .1f;
                    }
                    else
                        bd.angle = 0f;
                    Body myBody = getWorld().createBody(bd);
                    myBody.createFixture(fd);
                }
            }
        }
    }

    @Override
    public String getTestName()
    {
        return "Dominos";
    }
}
