/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model;

import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.ClassWrapper;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Relationship;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.UML;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Document
implements UML {
    protected List<ClassWrapper> classList = new ArrayList<ClassWrapper>();
    protected List<Relationship> relationshipList = new ArrayList<Relationship>();

    public ClassWrapper addClass(String pkg, String type, String name) {
        ClassWrapper c = new ClassWrapper(this, pkg, type, name);
        this.classList.add(c);
        return c;
    }

    public void addRelationship(Relationship r) {
        if (this.relationshipList.stream().noneMatch(i -> r.source().equals(i.source()) && r.target().equals(i.target()))) {
            this.relationshipList.add(r);
        }
    }

    public void removeForeignRelations() {
        this.relationshipList.removeIf(r -> this.classList.stream().noneMatch(c -> r.source().equals(c.name())) || this.classList.stream().noneMatch(c -> r.target().equals(c.name())));
    }

    public String export() {
        return this.getHeader() + this.classList.stream().map(c -> this.exportClass((ClassWrapper)c)).collect(Collectors.joining("\n")) + "\n" + this.relationshipList.stream().map(r -> this.exportRelationship((Relationship)r)).collect(Collectors.joining("\n")) + "\n" + this.getFooter();
    }

    protected abstract String getHeader();

    protected abstract String getFooter();

    protected abstract String exportClass(ClassWrapper var1);

    protected abstract String exportRelationship(Relationship var1);
}

