/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.export;

import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.ClassWrapper;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Document;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Relationship;
import java.util.stream.Collectors;

public class MermaidDocument
extends Document {
    @Override
    protected String getHeader() {
        return "classDiagram\n";
    }

    @Override
    protected String getFooter() {
        return "";
    }

    @Override
    protected String exportClass(ClassWrapper cw) {
        String fullname = (String)(cw.pkg() == null || cw.pkg().isBlank() ? "" : cw.pkg().replace(".", "_") + "_") + cw.name().replace(".", "_");
        String str = "class " + fullname + " { ";
        if (cw.type().contains("abstract")) {
            str = str + "\n<<abstract>>";
        }
        if (cw.type().contains("interface")) {
            str = str + "\n<<interface>>";
        }
        if (cw.type().contains("enum")) {
            str = str + "\n<<enum>>";
        }
        if (cw.type().contains("record")) {
            str = str + "\n<<record>>";
        }
        str = str + (String)(cw.fields().isEmpty() ? "" : "\n" + cw.fields().stream().map(f -> f.visibility().symbol() + " " + (String)(f.type().isBlank() ? "" : f.type().replaceAll("[<>]", "~") + " ") + f.name() + (f.isStatic() ? "$" : "")).collect(Collectors.joining("\n")));
        str = str + (String)(cw.methods().isEmpty() ? "" : "\n" + cw.methods().stream().map(m -> m.visibility().symbol() + " " + m.returnType().replaceAll("[<>]", "~") + " " + m.name() + "(" + m.parameters().stream().map(p -> p.replaceAll("[<>]", "~")).collect(Collectors.joining(",")) + ")" + (m.isAbstract() ? "*" : "") + (m.isStatic() ? "$" : "")).collect(Collectors.joining("\n")));
        str = str + "\n}\n";
        return str;
    }

    @Override
    protected String exportRelationship(Relationship r) {
        return r.source().replace(".", "_") + " " + (r.type().equals("+..") ? "<.." : r.type()) + " " + r.target().replace(".", "_") + (r.type().equals("+..") ? " : << contains >>" : "");
    }
}

