/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_cli.java2umltext;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.ASTVisitor;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.export.Format;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Document;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Visibility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

public class Client {
    public static void main(String[] args) throws IOException {
        System.setProperty("picocli.trace", "OFF");
        DefaultConfig defaults = new DefaultConfig();
        CommandLine cmd = new CommandLine((Object)defaults);
        cmd.parseArgs(args);
        if (cmd.isUsageHelpRequested()) {
            new CommandLine((Object)new Config()).usage(System.out);
        } else if (cmd.isVersionHelpRequested()) {
            new CommandLine((Object)new Config()).printVersionHelp(System.out);
        } else {
            cmd = new CommandLine((Object)new Config());
            cmd.setCaseInsensitiveEnumValuesAllowed(true);
            int exitCode = cmd.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new CommandLine.PropertiesDefaultProvider(defaults.configPath)).execute(args);
            System.exit(exitCode);
        }
    }

    @CommandLine.Command(mixinStandardHelpOptions=true)
    static class DefaultConfig {
        @CommandLine.Option(names={"-c", "--config"}, description={"Set options via a config file."})
        File configPath = new File(System.getProperty("user.dir"), "java2umltext.properties");
        @CommandLine.Unmatched
        List<String> remainder;

        DefaultConfig() {
        }
    }

    @CommandLine.Command(name="java2umltext", mixinStandardHelpOptions=true, version={"java2umltext 0.1"}, description={"Create UML Class Diagrams in text formats from Java source"})
    static class Config
    implements Runnable {
        @CommandLine.Option(names={"-c", "--config"}, description={"Set options via a config file."})
        File configPath = new File(System.getProperty("user.dir"), "java2umltext.properties");
        @CommandLine.Option(names={"-o"}, description={"Output file path"}, descriptionKey="output")
        Optional<File> outFilePath;
        @CommandLine.Option(names={"-l", "--language-level"}, defaultValue="JAVA_8", description={"Source code language level. One of ${COMPLETION-CANDIDATES}. Default: ${DEFAULT-VALUE}"}, descriptionKey="languageLevel")
        ParserConfiguration.LanguageLevel languageLevel;
        @CommandLine.Option(names={"-f", "--field-modifiers"}, defaultValue="public", description={"Field modifiers. One or more of ${COMPLETION-CANDIDATES}. Default: ${DEFAULT-VALUE}"}, descriptionKey="fieldModifiers")
        List<Visibility> fieldModifiers;
        @CommandLine.Option(names={"-m", "--method-modifiers"}, defaultValue="public", description={"Method modifiers. One or more of ${COMPLETION-CANDIDATES}. Default: ${DEFAULT-VALUE}"}, descriptionKey="methodModifiers")
        List<Visibility> methodModifiers;
        @CommandLine.Option(names={"--package"}, negatable=true, defaultValue="false", description={"Show package name. Default: ${DEFAULT-VALUE}"}, descriptionKey="package")
        boolean showPackage;
        @CommandLine.Option(names={"--constructors"}, negatable=true, defaultValue="true", description={"Show constructors. Default: ${DEFAULT-VALUE}"}, descriptionKey="constructors")
        boolean showConstructors;
        @CommandLine.Option(names={"--field-relationships"}, negatable=true, defaultValue="true", description={"Show relationships found based on field types. Default: ${DEFAULT-VALUE}"}, descriptionKey="fieldRelationships")
        boolean showFieldRelationships;
        @CommandLine.Option(names={"--method-relationships"}, negatable=true, defaultValue="true", description={"Show relationships found based on method return and parameter types. Default: ${DEFAULT-VALUE}"}, descriptionKey="methodRelationships")
        boolean showMethodRelationships;
        @CommandLine.Parameters(paramLabel="FORMAT", description={"Export format. One of ${COMPLETION-CANDIDATES}"})
        Format format;
        @CommandLine.Parameters(paramLabel="SOURCES", description={"Path to Java file or directory"})
        List<Path> sources;

        Config() {
        }

        @Override
        public void run() {
            Document doc = this.format.newDocument();
            StaticJavaParser.getParserConfiguration().setLanguageLevel(this.languageLevel);
            try {
                for (Path source : Config.multiWalk(this.sources, List.of(".java"))) {
                    CompilationUnit cu = StaticJavaParser.parse((File)source.toFile());
                    Optional pd = cu.getPackageDeclaration();
                    ASTVisitor v = new ASTVisitor(pd.isPresent() ? ((PackageDeclaration)pd.get()).getNameAsString() : "", this);
                    v.visit(cu, doc);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                System.exit(1);
            }
            doc.removeForeignRelations();
            if (!this.outFilePath.isPresent()) {
                System.out.println(doc.export());
            } else {
                if (this.outFilePath.get().isDirectory()) {
                    System.out.println("Error: output path is a directory.");
                    System.exit(1);
                } else if (!this.outFilePath.get().getParentFile().exists()) {
                    this.outFilePath.get().getParentFile().mkdirs();
                }
                try {
                    Files.writeString(this.outFilePath.get().toPath(), (CharSequence)doc.export(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(1);
                }
            }
        }

        private static Set<Path> multiWalk(Collection<Path> paths, Collection<String> extensions) {
            return paths.stream().flatMap(p -> {
                try {
                    return Files.walk(p, new FileVisitOption[0]);
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }).filter(p -> extensions.stream().anyMatch(e -> p.toString().endsWith((String)e))).map(p -> {
                try {
                    return p.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    return p;
                }
            }).collect(Collectors.toSet());
        }
    }
}

