/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_cli.java2umltext;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.Client;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.ClassWrapper;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Document;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.FieldWrapper;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.MethodWrapper;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Relationship;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.UML;
import de.pirckheimer_gymnasium.engine_pi_cli.java2umltext.model.Visibility;
import java.util.Optional;

public class ASTVisitor
extends VoidVisitorAdapter<UML> {
    private final String packageName;
    private final Client.Config config;

    public ASTVisitor(String packageName, Client.Config config) {
        this.packageName = packageName;
        this.config = config;
    }

    public void visit(ClassOrInterfaceDeclaration cid, UML el) {
        if (!(el instanceof Document)) {
            super.visit(cid, (Object)el);
            return;
        }
        this.parseClassLike((TypeDeclaration<?>)cid, (Document)el);
        super.visit(cid, (Object)el);
    }

    public void visit(EnumDeclaration ed, UML el) {
        if (!(el instanceof Document)) {
            super.visit(ed, (Object)el);
            return;
        }
        this.parseClassLike((TypeDeclaration<?>)ed, (Document)el);
        super.visit(ed, (Object)el);
    }

    public void visit(RecordDeclaration rd, UML el) {
        if (!(el instanceof Document)) {
            super.visit(rd, (Object)el);
            return;
        }
        this.parseClassLike((TypeDeclaration<?>)rd, (Document)el);
        super.visit(rd, (Object)el);
    }

    public void visit(EnumConstantDeclaration ecd, UML el) {
        if (!(el instanceof ClassWrapper)) {
            super.visit(ecd, (Object)el);
            return;
        }
        ClassWrapper cw = (ClassWrapper)el;
        cw.fields().add(new FieldWrapper(Visibility.PUBLIC, true, "", ecd.getNameAsString()));
    }

    public void visit(Parameter p, UML el) {
        if (!(el instanceof ClassWrapper)) {
            super.visit(p, (Object)el);
            return;
        }
        ClassWrapper cw = (ClassWrapper)el;
        if (cw.type().equals("record")) {
            cw.fields().add(new FieldWrapper(Visibility.PUBLIC, false, p.getTypeAsString(), p.getNameAsString()));
        }
    }

    public void visit(FieldDeclaration field, UML el) {
        if (!(el instanceof ClassWrapper)) {
            super.visit(field, (Object)el);
            return;
        }
        ClassWrapper cw = (ClassWrapper)el;
        Visibility v = ASTVisitor.getVisibility(field);
        if (this.config.fieldModifiers.contains((Object)v)) {
            boolean isStatic = field.isStatic();
            String type = ((VariableDeclarator)field.getVariables().getFirst().get()).getTypeAsString();
            String name = ((VariableDeclarator)field.getVariables().getFirst().get()).getNameAsString();
            cw.fields().add(new FieldWrapper(v, isStatic, type, name));
            if (this.config.showFieldRelationships) {
                this.addRelationship("--", field.getElementType(), cw);
            }
        }
    }

    public void visit(ConstructorDeclaration cd, UML el) {
        if (!(el instanceof ClassWrapper)) {
            super.visit(cd, (Object)el);
            return;
        }
        if (!this.config.showConstructors) {
            return;
        }
        ClassWrapper cw = (ClassWrapper)el;
        Visibility v = ASTVisitor.getVisibility(cd);
        if (this.config.methodModifiers.contains((Object)v)) {
            MethodWrapper mw = new MethodWrapper(v, cd.isStatic(), cd.isAbstract(), cw.name(), cd.getNameAsString());
            cw.methods().add(mw);
            for (Parameter parameter : cd.getParameters()) {
                mw.parameters().add(parameter.getTypeAsString());
            }
        }
    }

    public void visit(MethodDeclaration md, UML el) {
        if (!(el instanceof ClassWrapper)) {
            super.visit(md, (Object)el);
            return;
        }
        ClassWrapper cw = (ClassWrapper)el;
        Visibility v = ASTVisitor.getVisibility(md);
        if (this.config.methodModifiers.contains((Object)v)) {
            MethodWrapper mw = new MethodWrapper(v, md.isStatic(), md.isAbstract(), md.getTypeAsString(), md.getNameAsString());
            cw.methods().add(mw);
            for (Parameter parameter : md.getParameters()) {
                mw.parameters().add(parameter.getTypeAsString());
            }
            if (this.config.showMethodRelationships) {
                this.addRelationship("..", md.getType(), cw);
                for (Parameter parameter : md.getParameters()) {
                    this.addRelationship("..", parameter.getType(), cw);
                }
            }
        }
    }

    private void parseClassLike(TypeDeclaration<?> td, Document doc) {
        String pkg = this.config.showPackage ? this.packageName : "";
        Object name = td.getNameAsString();
        Node node = (Node)td.getParentNode().get();
        while (node instanceof ClassOrInterfaceDeclaration) {
            name = ((ClassOrInterfaceDeclaration)node).getNameAsString() + "." + (String)name;
            if (!((node = (Node)node.getParentNode().get()) instanceof CompilationUnit)) continue;
            doc.addRelationship(new Relationship("+..", ClassWrapper.pkgPrefix(pkg) + (String)name, ClassWrapper.pkgPrefix(pkg) + ((String)name).substring(0, ((String)name).lastIndexOf("."))));
        }
        String type = ASTVisitor.getDeclarationType(td);
        ClassWrapper cw = doc.addClass(pkg, type, (String)name);
        if (node instanceof CompilationUnit) {
            for (ImportDeclaration id : ((CompilationUnit)node).getImports()) {
                cw.imports().put(id.getName().getIdentifier(), id.getName().toString());
            }
        }
        for (ClassOrInterfaceType cit : ((NodeWithImplements)td).getImplementedTypes()) {
            this.addRelationship("<|..", cit.getElementType(), cw);
        }
        if (td instanceof ClassOrInterfaceDeclaration) {
            for (ClassOrInterfaceType cit : ((ClassOrInterfaceDeclaration)td).getExtendedTypes()) {
                this.addRelationship("<|--", cit.getElementType(), cw);
            }
        }
        td.getFields().forEach(f -> f.accept((VoidVisitor)this, (Object)cw));
        td.getConstructors().forEach(c -> c.accept((VoidVisitor)this, (Object)cw));
        td.getMethods().forEach(m -> m.accept((VoidVisitor)this, (Object)cw));
        if (td instanceof EnumDeclaration) {
            ((EnumDeclaration)td).getEntries().forEach(e -> e.accept((VoidVisitor)this, (Object)cw));
        }
        if (td instanceof RecordDeclaration) {
            ((RecordDeclaration)td).getParameters().forEach(p -> p.accept((VoidVisitor)this, (Object)cw));
        }
    }

    private void addRelationship(String relationship, Type type, ClassWrapper cw) {
        ClassOrInterfaceType classOrInterfaceType;
        Optional typeArguments;
        if (type instanceof ClassOrInterfaceType && (typeArguments = (classOrInterfaceType = type.asClassOrInterfaceType()).getTypeArguments()).isPresent()) {
            type = (Type)((NodeList)typeArguments.get()).get(0);
        }
        Object source = cw.pkgPrefix() + type.asString();
        if (cw.imports().containsKey(type.asString())) {
            source = this.config.showPackage ? cw.imports().get(type.asString()) : type.asString();
        }
        String target = cw.pkgPrefix() + cw.name();
        cw.document().addRelationship(new Relationship(relationship, (String)source, target));
    }

    private static String getDeclarationType(TypeDeclaration<?> td) {
        if (td instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration cid = (ClassOrInterfaceDeclaration)td;
            if (cid.isInterface()) {
                return "interface";
            }
            return (cid.getModifiers().stream().map(Node::toString).filter(m -> m.contains("abstract")).findAny().orElse("").trim() + " class").trim();
        }
        if (td instanceof EnumDeclaration) {
            return "enum";
        }
        if (td instanceof RecordDeclaration) {
            return "record";
        }
        return "";
    }

    private static <T extends Node> Visibility getVisibility(NodeWithModifiers<T> node) {
        return node.getModifiers().stream().map(Node::toString).map(Visibility::fromString).findFirst().orElse(Visibility.DEFAULT);
    }
}

