//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.2/demos/jax-rs/src/main/java/de/piratech/jaxrs/DasDingDemo.java $
//$Id: DasDingDemo.java 26 2012-10-07 23:22:51Z amuthmann@gmail.com $
package de.piratech.jaxrs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

/**
 * Demo for jax-rs
 *
 * @author deveth0
 */
@Path("/activities")
public class DasDingDemo {

  /**
   * http://localhost:8080/jax-rs/rest/activities
   *
   * @return
   */
  @GET
  @Produces(MediaType.APPLICATION_JSON)
  public List<Activity> getActivities() {
    Activity activity = new Activity();
    activity.setId(new Date().getTime());
    activity.setName("MyDemoActivity");
    activity.setDescription("foobar");
    List<Activity> ret = new ArrayList<Activity>();
    ret.add(activity);
    activity = new Activity();
    activity.setId(new Date().getTime());
    activity.setName("MyDemoActivity 2");
    activity.setDescription("bar foo");
    ret.add(activity);
    return ret;
  }

  /**
   * http://localhost:8080/jax-rs/rest/activities
   * POST:
   * id, name, description
   * 
   * @return
   */
  @POST
  @Produces(MediaType.APPLICATION_JSON)
  @Consumes("application/x-www-form-urlencoded")
  public Activity newActivity(@FormParam("id") String id,
          @FormParam("name") String name,
          @FormParam("description") String description,
          @Context HttpServletResponse servletResponse) throws IOException {
    Activity activity = new Activity();
    activity.setId(Long.parseLong(id));
    activity.setName(name);
    activity.setDescription(description);
    return activity;
  }

  /**
   * http://localhost:8080/jax-rs/rest/activities/213435
   *
   * @param id
   * @return
   */
  @GET
  @Path("{id}")
  public Activity getActivity(@PathParam("id") String id) {
    Activity activity = new Activity();
    activity.setId(Long.parseLong(id));
    activity.setName("getActivity");
    return activity;
  }
}
