//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/User.java $
//$Id: User.java 45 2012-10-12 14:13:28Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

/**
 *
 * @author deveth0
 */
@XmlRootElement
public class User extends AbstractDataObject {

  public enum USER_ROLE {

    VISITOR,
    USER,
    VERIFIED_USER,
    ADMIN
  }
  private String name;
  private String password;
  private String phone;
  private String mobile;
  private String mail;
  private List<ActionCategory> interests = new ArrayList<ActionCategory>();
  private List<Event> interestedIn = new ArrayList<Event>();
  private List<ActionApplication> actionApplications = new ArrayList<ActionApplication>();
  private List<USER_ROLE> roles = new ArrayList<USER_ROLE>();

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getMail() {
    return mail;
  }

  public void setMail(String mail) {
    this.mail = mail;
  }

  public List<USER_ROLE> getRoles() {
    return roles;
  }

  public void setRoles(List<USER_ROLE> role) {
    this.roles = role;
  }

  @XmlElementWrapper
  @XmlElement(name = "interest")
  @XmlIDREF
  public List<ActionCategory> getInterests() {
    return interests;
  }

  public void setInterests(List<ActionCategory> interests) {
    this.interests = interests;
  }

  public void addInterest(ActionCategory interest) {
    this.interests.add(interest);
  }

  @XmlElementWrapper
  @XmlElement(name = "interest")
  @XmlIDREF
  public List<Event> getInterestedIn() {
    return interestedIn;
  }

  public void setInterestedIn(List<Event> interestedIn) {
    this.interestedIn = interestedIn;
  }

  public void addInterestedIn(Event interestedIn) {
    this.interestedIn.add(interestedIn);
  }

  @XmlElementWrapper
  @XmlElement(name = "actionapplication")
  public List<ActionApplication> getActionApplications() {
    return actionApplications;
  }

  public void setActionApplications(List<ActionApplication> appliedActions) {
    this.actionApplications = appliedActions;
  }

  public void addActionApplication(Action appliedAction) {
    this.actionApplications.add(new ActionApplication(appliedAction));
  }

  @Override
  public boolean isValid() {
    return StringUtils.isNotBlank(name)
            && StringUtils.isNotBlank(password)
            && StringUtils.isNotBlank(mail);
  }
}
