//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/Location.java $
//$Id: Location.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

/**
 * A single location used to define a place where an event/action takes place
 *
 * @author deveth0
 */
@XmlRootElement
public class Location extends AbstractDataObject {

  private Double longitude;
  private Double latitude;
  private String name;
  private String street;
  private String zip;
  private String city;

  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getStreet() {
    return street;
  }

  public void setStreet(String street) {
    this.street = street;
  }

  public String getZip() {
    return zip;
  }

  public void setZip(String zip) {
    this.zip = zip;
  }

  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  @Override
  public boolean isValid() {
    return StringUtils.isNotBlank(name)
            && ((latitude != null && longitude != null)
            || (StringUtils.isNotBlank(street)
            && StringUtils.isNotBlank(zip)
            && StringUtils.isNotBlank(city)));
  }
}
