//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/Event.java $
//$Id: Event.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * An event
 *
 * @author deveth0
 */
@XmlRootElement
public class Event extends AbstractAction {

  public enum EVENTSTATUS {

    ACTIVE,
    CANCELED,
    FINISHED
  }
  private List<Action> actions = new ArrayList<Action>();
  private List<User> prospects = new ArrayList<User>();
  private EVENTSTATUS status = EVENTSTATUS.ACTIVE;
  private Event predecessor;
  private EventCategory category;

  @XmlElementWrapper
  @XmlElement(name = "action")
  public List<Action> getActions() {
    return actions;
  }

  public void addAction(Action action) {
    actions.add(action);
  }

  public void setActions(List<Action> actions) {
    this.actions = actions;
  }

  @XmlElementWrapper
  @XmlElement(name = "user")
  @XmlIDREF
  public List<User> getProspects() {
    return prospects;
  }

  public void setProspects(List<User> prospects) {
    this.prospects = prospects;
  }

  public EVENTSTATUS getStatus() {
    return status;
  }

  public void setStatus(EVENTSTATUS status) {
    this.status = status;
  }

  @XmlIDREF
  public Event getPredecessor() {
    return predecessor;
  }

  public void setPredecessor(Event predecessor) {
    this.predecessor = predecessor;
  }

  public EventCategory getCategory() {
    return category;
  }

  public void setCategory(EventCategory category) {
    this.category = category;
  }

  @Override
  public boolean isValid() {
    return super.isValid() && category != null;
  }
}
