//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/ActionApplication.java $
//$Id: ActionApplication.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * An application for an actino
 *
 * @author deveth0
 */
public class ActionApplication extends AbstractDataObject {

  public enum STATUS {

    ACCEPTED,
    PENDING,
    REFUSED
  }
  private STATUS status = STATUS.PENDING;
  private Action action;

  public ActionApplication() {
  }

  public ActionApplication(Action appliedAction) {
    this.action = appliedAction;
  }

  public STATUS getStatus() {
    return status;
  }

  public void setStatus(STATUS status) {
    this.status = status;
  }

  public Action getAction() {
    return action;
  }

  public void setAction(Action action) {
    this.action = action;
  }

  @Override
  public boolean isValid() {
    return status != null && action != null && action.isValid();
  }
}
