//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/Action.java $
//$Id: Action.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * An Action
 *
 * @author deveth0
 */
@XmlRootElement
public class Action extends AbstractAction {

  public enum ACTIONSTATUS {

    REQUIRES_PARTICIPANTS,
    WILL_HAPPEN,
    CANCELED
  }
  private ACTIONSTATUS status = ACTIONSTATUS.REQUIRES_PARTICIPANTS;
  private List<User> participants = new ArrayList<User>();
  private ActionCategory category;

  public ACTIONSTATUS getStatus() {
    return status;
  }

  public void setStatus(ACTIONSTATUS status) {
    this.status = status;
  }

  @XmlElementWrapper
  @XmlElement(name = "user")
  @XmlIDREF
  public List<User> getParticipants() {
    return participants;
  }

  public void setParticipants(List<User> participants) {
    this.participants = participants;
  }

  public ActionCategory getCategory() {
    return category;
  }

  public void setCategory(ActionCategory category) {
    this.category = category;
  }
  
  @Override
  public boolean isValid(){
    return super.isValid() && category != null;
  }
}
