//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/data/src/main/java/de/piratech/dasding/data/AbstractCategory.java $
//$Id: AbstractCategory.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.data;

import org.apache.commons.lang3.StringUtils;

/**
 * An abstract category with a name and description
 *
 * @author deveth0
 */
public abstract class AbstractCategory extends AbstractDataObject {

  private String name;
  private String description;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public boolean isValid() {
    return StringUtils.isNotBlank(name) && StringUtils.isNotBlank(description);
  }
}
