//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/UserResource.java $
//$Id: UserResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.User;
import de.piratech.dasding.data.helper.PasswordHelper;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * All actions for users
 *
 * @author deveth0
 */
@Path("/users")
public class UserResource {

  private static final Logger LOG = LoggerFactory.getLogger(UserResource.class);

  /**
   * Creates a new user
   *
   * http://localhost:8080/DasDing/api/users
   *
   * POST
   *
   * @param name (required)
   * @param password (required)
   * @param mail (required)
   * @param phone
   * @param mobile
   *
   * @return
   */
  @POST
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User createUser(
          @FormParam("name") String name,
          @FormParam("password") String password,
          @FormParam("phone") String phone,
          @FormParam("mobile") String mobile,
          @FormParam("mail") String mail) {
    LOG.debug("createEvent(name={}, phone={}, mobile={}, mail={})", name, phone, mobile, mail);
    User user = new User();
    user.setName(name);
    user.setPassword(PasswordHelper.getCryptedPassword(password, name));
    user.setMobile(mobile);
    user.setMail(mail);
    user.setPhone(phone);
    if (!user.isValid()) {
      throw new IllegalArgumentException("Not all required fields are set");
    }
    //TODO: save user in db
    user.setId("foo");
    return user;
  }
}
