//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/UserIdResource.java $
//$Id: UserIdResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.User;
import de.piratech.dasding.data.helper.PasswordHelper;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * resource for all calls for a specific user.
 *
 * Has to be restricted!
 *
 * @author deveth0
 */
@Path("/users/id/{id}")
public class UserIdResource {

  private static final Logger LOG = LoggerFactory.getLogger(UserIdResource.class);

  /**
   * Returns a single user by id
   *
   * http://localhost:8080/DasDing/api/users/1
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public User getUser(
          @PathParam("id") String id) {
    LOG.debug("getUser({})", id);
    //TODO: load user from db
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    User user = dc.create(User.class);
    user.setId(id);
    return user;
  }

  /**
   * Updates the user with the given id
   *
   * http://localhost:8080/DasDing/api/users/1
   *
   * PUT
   *
   * @param password
   * @param mail
   * @param phone
   * @param mobile
   *
   * @return
   */
  @PUT
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User updateUser(
          @PathParam("id") String id,
          @QueryParam("password") String password,
          @QueryParam("phone") String phone,
          @QueryParam("mobile") String mobile,
          @QueryParam("mail") String mail) {
    LOG.debug("updateUser(id={}, phone={}, mobile={}, mail={})", id, phone, mobile, mail);
    //TODO: load user from DB
    User user = new User();
    user.setId(id);
    user.setName(id);
    user.setPassword(id);
    user.setMail(id);
    if (StringUtils.isNotBlank(password)) {
      user.setPassword(PasswordHelper.getCryptedPassword(password, user.getName()));
    }
    if (StringUtils.isNotBlank(phone)) {
      user.setPhone(phone);
    }
    if (StringUtils.isNotBlank(mobile)) {
      user.setMobile(mobile);
    }
    if (StringUtils.isNotBlank(mail)) {
      user.setMail(mail);
    }
    if (!user.isValid()) {
      throw new IllegalArgumentException("User is invalid");
    }
    //TODO: add user to db
    return user;
  }

  /**
   * Deletes the given user
   *
   * http://localhost:8080/DasDing/api/users/1
   *
   * DELETE
   *
   * @param id
   */
  @DELETE
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public void deleteUser(@PathParam("id") String id) {
    LOG.debug("deleteUser({})", id);
    //TODO: remove user from DB
  }
}
