//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/UserIdInterestResource.java $
//$Id: UserIdInterestResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.ActionCategory;
import de.piratech.dasding.data.User;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * All actions depending on users interests
 *
 * Has to be restricted!
 *
 * @author deveth0
 */
@Path("/users/id/{id}/interests")
public class UserIdInterestResource {
  
  private static final Logger LOG = LoggerFactory.getLogger(UserIdInterestResource.class);

  /**
   * Gets all interests of the given user
   *
   * http://localhost:8080/DasDing/api/users/1/interests
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public List<ActionCategory> getInterests(
          @PathParam("id") Long id) {
    LOG.debug("getInterests()");
    //TODO: load interests from DB
    List<ActionCategory> ret = new ArrayList<ActionCategory>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(ActionCategory.class));
    }
    return ret;
  }

  /**
   * Adds the given interest to the given user
   *
   * http://localhost:8080/DasDing/api/users/1/interests
   *
   * POST
   *
   * @param userid
   * @param interestid
   * @return
   */
  @POST
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User addInterest(
          @PathParam("id") String id,
          @FormParam("interest") String interestid) {
    LOG.debug("addInterest(id={}, interest={})", id, interestid);
    //TODO: check if interest is in DB
    ActionCategory ac = new ActionCategory();
    ac.setId(interestid);
    ac.setName(interestid);
    ac.setDescription(interestid);
    if(!ac.isValid()) throw new IllegalArgumentException("Interest is not valid");
    //TODO: load user and add interest
    User user = new User();
    user.setId(id);
    user.addInterest(ac);
    //TODO: safe in db
    return user;
  }

  /**
   * deletes the given interest for the given user
   *
   * http://localhost:8080/DasDing/api/users/1/interests
   *
   * DELETE
   *
   * @param userid
   * @param interest
   * @return
   */
  @DELETE
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User deleteInterest(
          @PathParam("id") String id,
          @FormParam("interest") String interest) {
    LOG.debug("deleteInterest(interest={})", interest);
    //TODO: delete
    User user = new User();
    user.setId(id);
    return user;
  }
}
