//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/UserIdEventResource.java $
//$Id: UserIdEventResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Event;
import de.piratech.dasding.data.User;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * All actions depending on users events
 *
 * Has to be restricted!
 *
 * @author deveth0
 */
@Path("/users/id/{id}/events")
public class UserIdEventResource {

  private static final Logger LOG = LoggerFactory.getLogger(UserIdEventResource.class);

  /**
   * Gets all events of the given user
   *
   * http://localhost:8080/DasDing/api/users/1/events
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public List<Event> getEvents(
          @PathParam("id") Long id) {
    LOG.debug("getEvents()");
    //TODO: load events from DB
    List<Event> ret = new ArrayList<Event>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(Event.class));
    }
    return ret;
  }

  /**
   * Adds the given event as "interessted in" to the given user
   *
   * http://localhost:8080/DasDing/api/users/1/event
   *
   *
   *
   * @param userid
   * @param eventid
   * @return
   */
  @PUT
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User addEventAsInterest(
          @PathParam("id") String id,
          @QueryParam("event") String eventid) {
    LOG.debug("addEventAsInterest(id={}, event={})", id, eventid);
    //TODO: Load event from DB
    Event ev = new Event();
    ev.setId(eventid);
    if (!ev.isValid()) {
      throw new IllegalArgumentException("event is not valid");
    }
    //TODO: load user from DB and update
    User user = new User();
    user.setId(id);
    user.addInterestedIn(ev);
    return user;
  }

  /**
   * deletes the given event as interest for the given user
   *
   * http://localhost:8080/DasDing/api/users/1/events
   *
   * DELETE
   *
   * @param userid
   * @param eventid
   * @return
   */
  @DELETE
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User deleteEvent(
          @PathParam("id") String id,
          @FormParam("eventid") String eventid) {
    //TODO: delete event
    User user = new User();
    user.setId(id);
    return user;
  }
}
