//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/UserIdActionResource.java $
//$Id: UserIdActionResource.java 46 2012-10-12 14:14:32Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Action;
import de.piratech.dasding.data.User;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * All actions depending on users actions
 *
 * Has to be restricted!
 *
 * @author deveth0
 */
@Path("/users/id/{id}/actions")
public class UserIdActionResource {

  private static final Logger LOG = LoggerFactory.getLogger(UserIdActionResource.class);

  /**
   * Gets all actions of the given user
   *
   * http://localhost:8080/DasDing/api/users/1/actions
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public List<Action> getActions(
          @PathParam("id") Long id) {
    LOG.debug("getActions()");
    //TODO: load actions from DB
    List<Action> ret = new ArrayList<Action>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(Action.class));
    }
    return ret;
  }

  /**
   * Adds the given action to the given user
   *
   * http://localhost:8080/DasDing/api/users/1/actions
   *
   * POST
   *
   * @param userid
   * @param actionId
   * @return
   */
  @POST
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User addAction(
          @PathParam("id") String id,
          @FormParam("action") String actionId) {
    LOG.debug("addAction(id={}, action={})", id, actionId);
    //TODO: load action from DB
    Action ac = new Action();
    ac.setId(actionId);
    ac.setName(actionId);
    ac.setDescription(actionId);
    if (!ac.isValid()) {
      throw new IllegalArgumentException("Action is not valid");
    }
    //TODO: load user from DB and update
    User user = new User();
    user.setId(id);
    user.addActionApplication(ac);
    return user;
  }

  /**
   * deletes the given action for the given user
   *
   * http://localhost:8080/DasDing/api/users/1/actions
   *
   * DELETE
   *
   * @param userid
   * @param action
   * @return
   */
  @DELETE
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public User deleteAction(
          @PathParam("id") String id,
          @FormParam("action") String interest) {
    //TODO: load user and remove action
    User user = new User();
    user.setId(id);
    return user;
  }

  /**
   * Finds all actions fitting the users requirements
   *
   * http://localhost:8080/DasDing/api/users/1/actions/find
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Path("/find")
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public List<Action> findActions(
          @PathParam("id") Long id) {
    LOG.debug("findActions()");
    List<Action> ret = new ArrayList<Action>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(Action.class));
    }
    return ret;
  }
}
