//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/EventResource.java $
//$Id: EventResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Event;
import de.piratech.dasding.data.EventCategory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Event-Resource used by the REST Service
 *
 * @author deveth0
 */
@Path("/events")
public class EventResource {

  private static final Logger LOG = LoggerFactory.getLogger(EventResource.class);

  /**
   * Returns all events
   *
   * http://localhost:8080/DasDing/api/events
   *
   * GET
   *
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public List<Event> getEvents() {
    LOG.debug("getEvents()");
    //TODO: load events from DB
    List<Event> ret = new ArrayList<Event>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(Event.class));
    }
    return ret;
  }

  /**
   * Returns all events with the given parameters
   *
   * http://localhost:8080/DasDing/api/events/find?lat=10.31&lon=52.123
   *
   * http://localhost:8080/DasDing/api/events/find?lat=10.21&lon=52.123&distance=2.3
   *
   * GET
   *
   * @param lat
   * @param lon
   * @param distance (default: 5)
   * @param category
   * @return
   */
  @GET
  @Path("/find")
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public List<Event> findEvents(
          @QueryParam(value = "lat") float lat,
          @QueryParam(value = "lon") float lon,
          @DefaultValue(value = "5") @QueryParam(value = "distance") float distance,
          @QueryParam(value = "category") List<String> category) {
    LOG.debug("findEvents(lat={}, lon={}, distance={}, category={})", lat, lon, distance, category);
    //TODO: perform search
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    Event event = dc.create(Event.class);

    List<Event> ret = new ArrayList<Event>();
    ret.add(event);
    return ret;
  }

  /**
   * Creates an event
   *
   * http://localhost:8080/DasDing/api/events
   *
   * POST
   *
   * Restricted to verified users
   *
   * @param name (required)
   * @param description
   * @param time
   *
   * @return
   */
  @POST
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public Event createEvent(
          @FormParam("name") String name,
          @FormParam("description") String description,
          @FormParam("time") Long time) {
    LOG.debug("createEvent(name={}, description={}, time={})", name, description, time);
    Event event = new Event();
    event.setName(name);
    event.setDescription(description);
    event.setTime(new Date(time));
    if (!event.isValid()) {
      throw new IllegalArgumentException("Event is invalid");
    }
    //TODO: add event to database
    return event;
  }

  /**
   * Returns all event categories
   *
   * http://localhost:8080/DasDing/api/events/categories
   *
   * GET
   *
   * @return
   */
  @GET
  @Path("/categories")
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public List<EventCategory> getEventCategories() {
    LOG.debug("getEventCategories()");
    //TODO: load event categories from DB
    List<EventCategory> ret = new ArrayList<EventCategory>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(EventCategory.class));
    }
    return ret;
  }
}
