//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/ActionResource.java $
//$Id: ActionResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Action;
import de.piratech.dasding.data.ActionCategory;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The resource used to access actions
 *
 * @author deveth0
 */
@Path("/actions")
public class ActionResource {

  private static final Logger LOG = LoggerFactory.getLogger(ActionResource.class);

  /**
   * Returns a actions by coordinates, distance and categories
   *
   * http://localhost:8080/DasDing/api/actions/find?lat=10.31&lon=52.123
   * http://localhost:8080/DasDing/api/actions/find?lat=10.21&lon=52.123&distance=2.3
   * http://localhost:8080/DasDing/api/actions/find?lat=10.21&lon=52.123&category=cat1&category=cat2
   *
   * GET
   *
   * @param lat
   * @param lon
   * @param distance (default: 5)
   * @param category
   * @return
   */
  @GET
  @Path("/find")
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public List<Action> findActions(
          @QueryParam(value = "lat") float lat,
          @QueryParam(value = "lon") float lon,
          @DefaultValue(value = "5") @QueryParam(value = "distance") float distance,
          @QueryParam(value = "category") List<String> category) {
    LOG.debug("findActions(lat={}, lon={}, distance={}, category={})", lat, lon, distance, category);
    //TODO: perform search
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    Action action = dc.create(Action.class);

    List<Action> ret = new ArrayList<Action>();
    ret.add(action);
    return ret;
  }

  /**
   * Returns all action categories
   *
   * http://localhost:8080/DasDing/api/actions/categories
   *
   * GET
   *
   * @return
   */
  @GET
  @Path("/categories")
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public List<ActionCategory> getActionCategories() {
    LOG.debug("getActionCategories()");
    //TODO: load all action categories from DB
    List<ActionCategory> ret = new ArrayList<ActionCategory>();
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    for (int i = 0; i < 10; i++) {
      ret.add(dc.create(ActionCategory.class));
    }
    return ret;
  }
}
