//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/rest/ActionIdResource.java $
//$Id: ActionIdResource.java 44 2012-10-11 13:48:26Z amuthmann@gmail.com $
/*
 * Copyright 2012 Piratech.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Action;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Resource for all calls for an specific action
 *
 * @author deveth0
 */
@Path("/actions/id/{id}")
public class ActionIdResource {

  private static final Logger LOG = LoggerFactory.getLogger(ActionIdResource.class);

  /**
   * Returns a single action by id
   *
   * http://localhost:8080/DasDing/api/actions/id/1
   *
   * GET
   *
   * @param id
   * @return
   */
  @GET
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public Action getAction(
          @PathParam("id") String id) {
    LOG.debug("getEvent({})", id);
    //TODO: load action from db
    DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
    Action action = dc.create(Action.class);
    action.setId(id);
    return action;
  }

  /**
   * Updates the Action with the given id
   *
   * http://localhost:8080/DasDing/api/actions/id/1
   *
   * PUT
   *
   * @param id
   * @param name
   * @param description
   * @param time
   *
   * @return
   */
  @PUT
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  @Consumes(MediaType.APPLICATION_FORM_URLENCODED)
  public Action updateAction(
          @PathParam("id") String id,
          @QueryParam("name") String name,
          @QueryParam("description") String description,
          @QueryParam("time") Long time) {
    LOG.debug("updateAction(id={}, name={}, description={}, time={})", id, name, description, time);
    Action action = new Action();
    action.setId(id);
    if (StringUtils.isNotBlank(name)) {
      action.setName(name);
    }
    if (StringUtils.isNotBlank(description)) {
      action.setDescription(description);
    }
    if (time != null) {
      action.setTime(new Date(time));
    }
    if (!action.isValid()) {
      throw new IllegalArgumentException("action not valid");
    }
    return action;
  }

  /**
   * Sets the given action to status "Canceled"
   *
   * http://localhost:8080/DasDing/api/action/id/1
   *
   * DELETE
   *
   * @param id
   */
  @DELETE
  @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
  public void deleteAction(@PathParam("id") String id) {
    LOG.debug("deleteAction({})", id);
    //TODO: set action status to canceled
  }
}
