//$URL: https://dasding.googlecode.com/svn/tags/dasding-0.3/api/src/main/java/de/piratech/dasding/api/config/UriExtensionsConfig.java $
//$Id: UriExtensionsConfig.java 31 2012-10-09 17:09:14Z amuthmann@gmail.com $
/*
 * Copyright 2012 deveth0.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.piratech.dasding.api.config;

import java.util.*;
import javax.ws.rs.core.*;
import com.sun.jersey.api.core.*;

/**
 * @see http://zcox.wordpress.com/2009/08/11/uri-extensions-in-jersey/
 * @author deveth0
 */
public class UriExtensionsConfig extends PackagesResourceConfig {

  private Map<String, MediaType> mediaTypeMap;

  public UriExtensionsConfig() {
    super();
  }

  public UriExtensionsConfig(Map<String, Object> props) {
    super(props);
  }

  public UriExtensionsConfig(String[] paths) {
    super(paths);
  }

  @Override
  public Map<String, MediaType> getMediaTypeMappings() {
    if (mediaTypeMap == null) {
      mediaTypeMap = new HashMap<String, MediaType>();
      mediaTypeMap.put("json", MediaType.APPLICATION_JSON_TYPE);
      mediaTypeMap.put("xml", MediaType.APPLICATION_XML_TYPE);
      mediaTypeMap.put("kml", new MediaType("application", "vnd.google-earth.kml+xml"));
      mediaTypeMap.put("html", MediaType.TEXT_HTML_TYPE);
    }
    return mediaTypeMap;
  }
}
