/*
 * Decompiled with CFR 0.152.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.User;
import de.piratech.dasding.data.helper.PasswordHelper;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/users")
public class UserResource {
    private static final Logger LOG = LoggerFactory.getLogger(UserResource.class);

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public User createUser(@FormParam(value="name") String name, @FormParam(value="password") String password, @FormParam(value="phone") String phone, @FormParam(value="mobile") String mobile, @FormParam(value="mail") String mail) {
        LOG.debug("createEvent(name={}, phone={}, mobile={}, mail={})", new Object[]{name, phone, mobile, mail});
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)mail)) {
            IllegalArgumentException toThrow = new IllegalArgumentException("Not all required fields are set");
            LOG.error("", (Throwable)toThrow);
            throw toThrow;
        }
        User user = new User();
        user.setName(name);
        user.setPassword(PasswordHelper.getCryptedPassword((String)password, (String)name));
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            user.setMobile(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)mail)) {
            user.setMail(mail);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            user.setPhone(phone);
        }
        user.setId(Long.valueOf(Long.MAX_VALUE));
        return user;
    }
}

