/*
 * Decompiled with CFR 0.152.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.User;
import de.piratech.dasding.data.helper.PasswordHelper;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/users/id/{id}")
public class UserIdResource {
    private static final Logger LOG = LoggerFactory.getLogger(UserIdResource.class);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public User getUser(@PathParam(value="id") Long id) {
        LOG.debug("getUser({})", (Object)id);
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        User user = (User)dc.create(User.class);
        user.setId(id);
        return user;
    }

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public User updateUser(@PathParam(value="id") Long id, @QueryParam(value="password") String password, @QueryParam(value="phone") String phone, @QueryParam(value="mobile") String mobile, @QueryParam(value="mail") String mail) {
        LOG.debug("updateUser(id={}, phone={}, mobile={}, mail={})", new Object[]{id, phone, mobile, mail});
        User user = new User();
        user.setId(id);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            user.setPassword(PasswordHelper.getCryptedPassword((String)password, (String)user.getName()));
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            user.setPhone(phone);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            user.setMobile(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)mail)) {
            user.setMail(mail);
        }
        return user;
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void deleteUser(@PathParam(value="id") String id) {
        LOG.debug("deleteUser({})", (Object)id);
    }
}

