/*
 * Decompiled with CFR 0.152.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Event;
import de.piratech.dasding.data.EventCategory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/events")
public class EventResource {
    private static final Logger LOG = LoggerFactory.getLogger(EventResource.class);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<Event> getEvents() {
        LOG.debug("getEvents()");
        ArrayList<Event> ret = new ArrayList<Event>();
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        for (int i = 0; i < 10; ++i) {
            ret.add((Event)dc.create(Event.class));
        }
        return ret;
    }

    @GET
    @Path(value="/find")
    @Produces(value={"application/json", "application/xml"})
    public List<Event> findEvents(@QueryParam(value="lat") float lat, @QueryParam(value="lon") float lon, @DefaultValue(value="5") @QueryParam(value="distance") float distance, @QueryParam(value="category") List<String> category) {
        LOG.debug("findEvents(lat={}, lon={}, distance={}, category={})", new Object[]{Float.valueOf(lat), Float.valueOf(lon), Float.valueOf(distance), category});
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        Event event = (Event)dc.create(Event.class);
        ArrayList<Event> ret = new ArrayList<Event>();
        ret.add(event);
        return ret;
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Event createEvent(@FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="time") Long time) {
        LOG.debug("createEvent(name={}, description={}, time={})", new Object[]{name, description, time});
        if (StringUtils.isBlank((CharSequence)name)) {
            IllegalArgumentException toThrow = new IllegalArgumentException("Not all required fields are set");
            LOG.error("", (Throwable)toThrow);
            throw toThrow;
        }
        Event event = new Event();
        event.setName(name);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            event.setDescription(description);
        }
        if (time != null) {
            event.setTime(new Date(time));
        }
        return event;
    }

    @GET
    @Path(value="/categories")
    @Produces(value={"application/json", "application/xml"})
    public List<EventCategory> getEventCategories() {
        LOG.debug("getEventCategories()");
        ArrayList<EventCategory> ret = new ArrayList<EventCategory>();
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        for (int i = 0; i < 10; ++i) {
            ret.add((EventCategory)dc.create(EventCategory.class));
        }
        return ret;
    }
}

