/*
 * Decompiled with CFR 0.152.
 */
package de.piratech.dasding.api.rest;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.piratech.dasding.data.Action;
import de.piratech.dasding.data.Event;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/events/id/{id}")
public class EventIdResource {
    private static final Logger LOG = LoggerFactory.getLogger(EventIdResource.class);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Event getEvent(@PathParam(value="id") Long id) {
        LOG.debug("getEvent({})", (Object)id);
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        Event event = (Event)dc.create(Event.class);
        event.setId(id);
        return event;
    }

    @GET
    @Produces(value={"application/vnd.google-earth.kml+xml"})
    public Document getEventAsKML(@PathParam(value="id") Long id) {
        LOG.debug("getEventAsKML({})", (Object)id);
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        Event event = (Event)dc.create(Event.class);
        Document document = new Document();
        document.createAndAddPlacemark().withName(event.getName()).withDescription(event.getDescription()).createAndSetPoint().addToCoordinates(event.getLocation().getLongitude(), event.getLocation().getLatitude());
        if (!event.getActions().isEmpty()) {
            Folder actions = document.createAndAddFolder().withName("actions");
            for (Action action : event.getActions()) {
                System.out.println("action: " + action.getLocation().getLongitude());
                actions.createAndAddPlacemark().withName(action.getName()).withDescription(action.getDescription()).createAndSetPoint().addToCoordinates(action.getLocation().getLongitude(), action.getLocation().getLatitude());
            }
        }
        return document;
    }

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Event updateEvent(@PathParam(value="id") Long id, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="time") Long time) {
        LOG.debug("updateEvent(id={}, name={}, description={}, time={})", new Object[]{id, name, description, time});
        Event event = new Event();
        event.setId(id);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            event.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            event.setDescription(description);
        }
        if (time != null) {
            event.setTime(new Date(time));
        }
        return event;
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    public Event deleteEvent(@PathParam(value="id") Long id) {
        LOG.debug("deleteEvent({})", (Object)id);
        Event event = new Event();
        event.setId(id);
        event.setStatus(Event.EVENTSTATUS.CANCELED);
        return event;
    }

    @Path(value="/createAction")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Event createAction(@PathParam(value="id") Long id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="time") Long time) {
        LOG.debug("createAction({})", (Object)id);
        Event event = new Event();
        event.setId(id);
        Action action = new Action();
        action.setName(name);
        action.setDescription(description);
        action.setTime(new Date(time));
        event.addAction(action);
        return event;
    }
}

