/*
 * Decompiled with CFR 0.152.
 */
package de.piratech.dasding.api.rest;

import de.piratech.dasding.data.Action;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.dummycreator.ClassBindings;
import org.dummycreator.DummyCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/actions/id/{id}")
public class ActionIdResource {
    private static final Logger LOG = LoggerFactory.getLogger(ActionIdResource.class);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Action getAction(@PathParam(value="id") Long id) {
        LOG.debug("getEvent({})", (Object)id);
        DummyCreator dc = new DummyCreator(ClassBindings.defaultBindings());
        Action action = (Action)dc.create(Action.class);
        action.setId(id);
        return action;
    }

    @PUT
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Action updateAction(@PathParam(value="id") Long id, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="time") Long time) {
        LOG.debug("updateAction(id={}, name={}, description={}, time={})", new Object[]{id, name, description, time});
        Action action = new Action();
        action.setId(id);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            action.setName(name);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            action.setDescription(description);
        }
        if (time != null) {
            action.setTime(new Date(time));
        }
        return action;
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    public void deleteAction(@PathParam(value="id") String id) {
        LOG.debug("deleteAction({})", (Object)id);
    }
}

