/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="testparser", requiresProject=false)
public class TestParserMojo
extends AbstractMojo {
    private static final String SKIPPED = "skipped";
    @Parameter(property="testparser.resultsDirectory", required=true)
    File resultsDirectory;

    public void execute() throws MojoExecutionException {
        List parsedReports;
        if (!this.resultsDirectory.isDirectory()) {
            throw new MojoExecutionException(String.valueOf(this.resultsDirectory) + " is not a directory");
        }
        this.getLog().debug((CharSequence)("Checking test results in " + String.valueOf(this.resultsDirectory)));
        List<File> reportDirectories = TestParserMojo.collectReportDirectoriesRecursively(this.resultsDirectory);
        SurefireReportParser parser = new SurefireReportParser(reportDirectories, Locale.getDefault());
        try {
            parsedReports = parser.parseXMLReportFiles();
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Could not parse XML reports", (Exception)((Object)e));
        }
        if (parsedReports.isEmpty()) {
            this.getLog().warn((CharSequence)("Did not find any XML reports in " + String.valueOf(this.resultsDirectory)));
        }
        ArrayList<String> failures = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (ReportTestSuite testSuite : parsedReports) {
            if (testSuite.getNumberOfErrors() > 0) {
                errors.add(testSuite.getFullClassName());
            }
            for (ReportTestCase testCase : testSuite.getTestCases()) {
                if (!testCase.hasFailure() || testCase.getFailureType().equals(SKIPPED)) continue;
                failures.add(testCase.getFullName());
            }
        }
        if (!errors.isEmpty()) {
            this.getLog().info((CharSequence)"Errors:");
            this.logLines(errors);
        }
        if (!failures.isEmpty()) {
            this.getLog().info((CharSequence)"Failures:");
            this.logLines(failures);
        }
        Map summary = parser.getSummary(parsedReports);
        this.getLog().info((CharSequence)String.format("Tests run: %s, Failures: %s, Errors: %s, Skipped: %s", summary.get("totalTests"), summary.get("totalFailures"), summary.get("totalErrors"), summary.get("totalSkipped")));
        if (!errors.isEmpty() && !failures.isEmpty()) {
            throw new MojoExecutionException("There were test errors and failures.");
        }
        if (!errors.isEmpty()) {
            throw new MojoExecutionException("There were test errors.");
        }
        if (!failures.isEmpty()) {
            throw new MojoExecutionException("There were test failures.");
        }
    }

    static List<File> collectReportDirectoriesRecursively(File rootDirectory) throws MojoExecutionException {
        if (rootDirectory == null) {
            throw new MojoExecutionException("No valid directory provided");
        }
        if (!rootDirectory.exists()) {
            throw new MojoExecutionException("Directory " + String.valueOf(rootDirectory) + " does not exist");
        }
        if (!rootDirectory.isDirectory()) {
            throw new MojoExecutionException("Directory " + String.valueOf(rootDirectory) + " is no directory");
        }
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(rootDirectory);
        for (File child : rootDirectory.listFiles()) {
            if (!child.isDirectory()) continue;
            ret.addAll(TestParserMojo.collectReportDirectoriesRecursively(child));
        }
        return ret;
    }

    private void logLines(List<String> lines) {
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }
}

