/*
 * Decompiled with CFR 0.152.
 */
package de.philipp_bobek.oss_licenses_parser;

import de.philipp_bobek.oss_licenses_parser.ThirdPartyLicense;
import de.philipp_bobek.oss_licenses_parser.ThirdPartyLicenseMetadata;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/philipp_bobek/oss_licenses_parser/OssLicensesParser;", "", "<init>", "()V", "licenseMetadataLineRegex", "Lkotlin/text/Regex;", "parseAllLicenses", "", "Lde/philipp_bobek/oss_licenses_parser/ThirdPartyLicense;", "thirdPartyLicensesMetadataFile", "Ljava/io/InputStream;", "thirdPartyLicensesFile", "parseMetadata", "Lde/philipp_bobek/oss_licenses_parser/ThirdPartyLicenseMetadata;", "metadataLines", "Lkotlin/sequences/Sequence;", "", "getLicenseMetadata", "metadataLine", "parseLicense", "licensesBytes", "", "metadata", "oss-licenses-parser"})
@SourceDebugExtension(value={"SMAP\nOssLicensesParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OssLicensesParser.kt\nde/philipp_bobek/oss_licenses_parser/OssLicensesParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n57#3:125\n1#4:126\n1#4:127\n*S KotlinDebug\n*F\n+ 1 OssLicensesParser.kt\nde/philipp_bobek/oss_licenses_parser/OssLicensesParser\n*L\n55#1:121\n55#1:122,3\n72#1:125\n72#1:126\n*E\n"})
public final class OssLicensesParser {
    @NotNull
    public static final OssLicensesParser INSTANCE = new OssLicensesParser();
    @NotNull
    private static final Regex licenseMetadataLineRegex = new Regex("^(?<offset>\\d+):(?<length>\\d+) (?<libraryName>.+)$");

    private OssLicensesParser() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<ThirdPartyLicense> parseAllLicenses(@NotNull InputStream thirdPartyLicensesMetadataFile, @NotNull InputStream thirdPartyLicensesFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)thirdPartyLicensesMetadataFile, (String)"thirdPartyLicensesMetadataFile");
        Intrinsics.checkNotNullParameter((Object)thirdPartyLicensesFile, (String)"thirdPartyLicensesFile");
        byte[] licensesBytes = ByteStreamsKt.readBytes((InputStream)thirdPartyLicensesFile);
        Iterable $this$map$iv = OssLicensesParser.parseMetadata(thirdPartyLicensesMetadataFile);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void metadata;
            ThirdPartyLicenseMetadata thirdPartyLicenseMetadata = (ThirdPartyLicenseMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.parseLicense(licensesBytes, (ThirdPartyLicenseMetadata)metadata));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<ThirdPartyLicenseMetadata> parseMetadata(@NotNull InputStream thirdPartyLicensesMetadataFile) {
        List<ThirdPartyLicenseMetadata> list;
        Intrinsics.checkNotNullParameter((Object)thirdPartyLicensesMetadataFile, (String)"thirdPartyLicensesMetadataFile");
        InputStream inputStream = thirdPartyLicensesMetadataFile;
        Charset charset = Charsets.UTF_8;
        Reader $this$useLines$iv = new InputStreamReader(inputStream, charset);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence licenseMetadataLines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            list = INSTANCE.parseMetadata((Sequence<String>)licenseMetadataLines);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    private final List<ThirdPartyLicenseMetadata> parseMetadata(Sequence<String> metadataLines) {
        return SequencesKt.toList((Sequence)SequencesKt.map(metadataLines, (Function1)((Function1)new Function1<String, ThirdPartyLicenseMetadata>((Object)this){

            public final ThirdPartyLicenseMetadata invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OssLicensesParser.access$getLicenseMetadata((OssLicensesParser)this.receiver, p0);
            }
        })));
    }

    private final ThirdPartyLicenseMetadata getLicenseMetadata(String metadataLine) {
        MatchResult matchResult = Regex.find$default((Regex)licenseMetadataLineRegex, (CharSequence)metadataLine, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new IllegalArgumentException("Metadata line invalid: " + metadataLine);
        }
        MatchResult matchResult2 = matchResult;
        Object object = matchResult2.getGroups().get(1);
        if (object == null || (object = object.getValue()) == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
            throw new IllegalArgumentException("Metadata offset invalid: " + metadataLine);
        }
        long offset = (Long)object;
        Object object2 = matchResult2.getGroups().get(2);
        if (object2 == null || (object2 = object2.getValue()) == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
            throw new IllegalArgumentException("Metadata length invalid: " + metadataLine);
        }
        int length = (Integer)object2;
        Object object3 = matchResult2.getGroups().get(3);
        if (object3 == null || (object3 = object3.getValue()) == null) {
            throw new IllegalArgumentException("Metadata library name invalid: " + metadataLine);
        }
        Object libraryName = object3;
        return new ThirdPartyLicenseMetadata((String)libraryName, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ThirdPartyLicense parseLicense(byte[] licensesBytes, ThirdPartyLicenseMetadata metadata) {
        ThirdPartyLicense thirdPartyLicense;
        Closeable closeable = new ByteArrayInputStream(licensesBytes);
        Throwable throwable = null;
        try {
            ByteArrayInputStream licensesFile = (ByteArrayInputStream)closeable;
            boolean bl = false;
            thirdPartyLicense = OssLicensesParser.parseLicense(metadata, licensesFile);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return thirdPartyLicense;
    }

    @JvmStatic
    @NotNull
    public static final ThirdPartyLicense parseLicense(@NotNull ThirdPartyLicenseMetadata metadata, @NotNull InputStream thirdPartyLicensesFile) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)thirdPartyLicensesFile, (String)"thirdPartyLicensesFile");
        long bytesSkipped = thirdPartyLicensesFile.skip(metadata.getOffset());
        if (bytesSkipped != metadata.getOffset()) {
            throw new EOFException();
        }
        byte[] bytes = new byte[metadata.getLength()];
        int bytesRead = thirdPartyLicensesFile.read(bytes);
        if (bytesRead != metadata.getLength()) {
            throw new EOFException();
        }
        return new ThirdPartyLicense(metadata.getLibraryName(), StringsKt.decodeToString((byte[])bytes));
    }

    public static final /* synthetic */ ThirdPartyLicenseMetadata access$getLicenseMetadata(OssLicensesParser $this, String metadataLine) {
        return $this.getLicenseMetadata(metadataLine);
    }
}

