/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.pluginupdater;

import de.pheasn.pluginupdater.ReleaseChannel;
import java.util.Arrays;

public final class PluginVersion
implements Comparable<PluginVersion> {
    private final int[] versionArr;
    private final String versionString;
    private final ReleaseChannel releaseChannel;

    public PluginVersion(String versionString, ReleaseChannel releaseChannel) {
        if (versionString == null) {
            throw new NullPointerException("versionString null");
        }
        versionString = this.removeNonNumeric(versionString);
        this.releaseChannel = releaseChannel;
        if (versionString.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] split = versionString.split("\\.");
        this.versionArr = new int[split.length];
        StringBuilder sb = new StringBuilder(split.length * 3);
        try {
            for (int i = 0; i < split.length; ++i) {
                if (split[i].isEmpty()) {
                    throw new IllegalArgumentException();
                }
                this.versionArr[i] = Integer.parseInt(split[i]);
                sb.append(this.versionArr[i] + ".");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        sb.deleteCharAt(sb.length() - 1);
        this.versionString = sb.toString();
    }

    public String getVersion() {
        return this.versionString;
    }

    public ReleaseChannel getReleaseChannel() {
        return this.releaseChannel;
    }

    private String removeNonNumeric(String inputString) {
        StringBuilder output = new StringBuilder();
        for (char c : inputString.toCharArray()) {
            if (!Character.isDigit(c) && c != '.') continue;
            output.append(c);
        }
        return output.toString();
    }

    @Override
    public int compareTo(PluginVersion v2) {
        int index2;
        int index;
        for (index = 0; index < this.versionArr.length && index < v2.versionArr.length; ++index) {
            if (this.versionArr[index] > v2.versionArr[index]) {
                return 1;
            }
            if (this.versionArr[index] >= v2.versionArr[index]) continue;
            return -1;
        }
        if (index == v2.versionArr.length && index == this.versionArr.length) {
            if (this.releaseChannel == null) {
                return -1;
            }
            if (v2.releaseChannel == null) {
                return 1;
            }
            return this.releaseChannel.compareTo(v2.releaseChannel);
        }
        for (index2 = index; index2 < this.versionArr.length; ++index2) {
            if (this.versionArr[index2] == 0) continue;
            return 1;
        }
        for (index2 = index; index2 < v2.versionArr.length; ++index2) {
            if (v2.versionArr[index2] == 0) continue;
            return -1;
        }
        if (this.releaseChannel == null) {
            return -1;
        }
        if (v2.releaseChannel == null) {
            return 1;
        }
        return this.releaseChannel.compareTo(v2.releaseChannel);
    }

    public boolean isSignificantlyNewerThan(PluginVersion version2, int significance) {
        int index;
        for (index = 0; index <= significance && index < this.versionArr.length && index < version2.versionArr.length; ++index) {
            if (this.versionArr[index] <= version2.versionArr[index]) continue;
            return true;
        }
        while (index <= significance && index < this.versionArr.length) {
            if (this.versionArr[index] != 0) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public int hashCode() {
        int prime = 61;
        int result = 7;
        result = 61 * result + (this.releaseChannel == null ? 0 : this.releaseChannel.hashCode());
        boolean nonZeroFound = false;
        for (int i = this.versionArr.length - 1; i >= 0; --i) {
            if (this.versionArr[i] != 0) {
                nonZeroFound = true;
            }
            if (!nonZeroFound) continue;
            result = 61 * result + this.versionArr[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginVersion other = (PluginVersion)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return "PluginVersion [versionArr=" + Arrays.toString(this.versionArr) + ", releaseChannel=" + (Object)((Object)this.releaseChannel) + "]";
    }
}

