/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.pluginupdater;

import de.pheasn.pluginupdater.PluginVersion;
import de.pheasn.pluginupdater.ReleaseChannel;
import de.pheasn.pluginupdater.Updatable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater {
    private static final String API_NAME_VALUE = "name";
    private static final String API_LINK_VALUE = "downloadUrl";
    private static final String API_RELEASE_TYPE_VALUE = "releaseType";
    private static final String API_QUERY = "/servermods/files?projectIds=";
    private static final String API_HOST = "https://api.curseforge.com";
    private static final int MIN_INTERVAL = 5;
    private static final int DEFAULT_INTERVAL = 18;
    private final Updatable plugin;
    private final int pluginId;
    private final String apiKey;
    private final ReleaseChannel channel;
    private final TimerTask timerTask;
    private Timer timer;
    private boolean updatePending = false;

    private Updater(Updatable plugin, int pluginId, String apiKey, ReleaseChannel channel, int interval) {
        this.plugin = plugin;
        this.pluginId = pluginId;
        this.apiKey = apiKey;
        this.channel = channel;
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Updater.this.checkForUpdate();
            }
        };
        this.setInterval(interval);
    }

    public void setInterval(int interval) {
        long msInterval = (interval < 5 ? 18 : interval) * 60 * 1000;
        this.cancel();
        this.timer.schedule(this.getTimerTask(), msInterval, msInterval);
    }

    public void cancel() {
        this.timer.cancel();
        this.timer = new Timer();
    }

    void checkForUpdate() {
        if (this.updatePending) {
            return;
        }
        this.updatePending = true;
        URL url = null;
        try {
            url = new URL("https://api.curseforge.com/servermods/files?projectIds=" + this.pluginId);
        }
        catch (MalformedURLException e) {
            this.updatePending = false;
            return;
        }
        try {
            URLConnection con = url.openConnection();
            if (this.apiKey != null) {
                con.addRequestProperty("X-API-Key", this.apiKey);
            }
            con.addRequestProperty("User-Agent", "PluginUpdater by Pheasn");
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String response = reader.readLine();
            JSONArray array = (JSONArray)JSONValue.parse((String)response);
            if (!array.isEmpty()) {
                for (int i = array.size() - 1; i >= 0; --i) {
                    JSONObject version = (JSONObject)array.get(i);
                    String versionLink = (String)version.get((Object)API_LINK_VALUE);
                    String versionName = (String)version.get((Object)API_NAME_VALUE);
                    String releaseTypeName = ((String)version.get((Object)API_RELEASE_TYPE_VALUE)).toUpperCase();
                    ReleaseChannel pendingChannel = ReleaseChannel.parse(releaseTypeName);
                    if (pendingChannel.compareTo(this.channel) < 0) continue;
                    PluginVersion pendingVersion = new PluginVersion(versionName, pendingChannel);
                    PluginVersion currentVersion = new PluginVersion(this.plugin.getVersion(), this.plugin.getReleaseChannel());
                    if (pendingVersion.compareTo(currentVersion) == 1) {
                        int fetched;
                        File file = new File("./plugins/update", this.plugin.getFile().getName());
                        file.getParentFile().mkdirs();
                        if (file.exists() && !file.delete()) {
                            this.updatePending = false;
                            break;
                        }
                        if (!file.createNewFile()) {
                            this.updatePending = false;
                            break;
                        }
                        URL dwnurl = new URL(versionLink);
                        InputStream in = dwnurl.openStream();
                        FileOutputStream out = new FileOutputStream(file);
                        byte[] buffer = new byte[4096];
                        while ((fetched = in.read(buffer)) != -1) {
                            out.write(buffer, 0, fetched);
                        }
                        out.close();
                        in.close();
                        this.plugin.updateNotify(versionName);
                        break;
                    }
                    this.updatePending = false;
                    break;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            this.updatePending = false;
        }
    }

    private TimerTask getTimerTask() {
        return this.timerTask;
    }

    public static class Builder {
        private final Updatable plugin;
        private final int pluginId;
        private String apiKey = null;
        private ReleaseChannel channel = ReleaseChannel.STABLE;
        private int interval = 18;

        public Builder(Updatable plugin, int pluginId) {
            if (plugin == null) {
                throw new NullPointerException("Plugin can't be null");
            }
            this.plugin = plugin;
            this.pluginId = pluginId;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder channel(ReleaseChannel channel) {
            if (channel == null) {
                throw new NullPointerException("ReleaseChannel can't be null");
            }
            this.channel = channel;
            return this;
        }

        public Builder interval(int interval) throws IllegalArgumentException {
            if (interval < 5) {
                throw new IllegalArgumentException("Interval must be greater or equal 5 minutes");
            }
            this.interval = interval;
            return this;
        }

        public Updater build() {
            return new Updater(this.plugin, this.pluginId, this.apiKey, this.channel, this.interval);
        }
    }
}

