package de.pheasn.pluginupdater;

import java.util.TimerTask;

public class UpdateCheckTask extends TimerTask {
	private Updater updater;
	private Updatable plugin;

	public UpdateCheckTask(Updater updater, Updatable plugin) {
		this.updater = updater;
		this.plugin = plugin;
	}

	@SuppressWarnings("deprecation")
	@Override
	public void run() {
		if (!updater.hasUpdatePending()) {
			if (updater.check()) {
				plugin.updateNotifyDownloading();
			}
		} else {
			plugin.updateNotifyRestarting();
		}
		updater.scheduleNext();
	}
}
