package de.pheasn.pluginupdater;

public class PluginVersion implements Comparable<PluginVersion> {

	private final int[] versionArr;
	private final ReleaseType releaseType;

	public PluginVersion(String versionString, ReleaseType releaseType) {
		versionString = removeNonNumeric(versionString);
		this.releaseType = releaseType;

		String[] splitted = versionString.split("\\.");
		versionArr = new int[splitted.length];
		for (int i = 0; i < splitted.length; i++) {
			versionArr[i] = Integer.parseInt(splitted[i]);
		}
	}

	private String removeNonNumeric(String inputString) {
		StringBuilder output = new StringBuilder();
		for (char c : inputString.toCharArray()) {
			if (Character.isDigit(c) || c == '.') {
				output.append(c);
			}
		}
		return output.toString();
	}

	@Override
	public int compareTo(PluginVersion v2) {
		int i = 0;
		while (i < versionArr.length && i < v2.versionArr.length) {
			if (versionArr[i] > v2.versionArr[i]) return 1;
			else if (versionArr[i] < v2.versionArr[i]) return -1;
			i++;
		}
		// if both array index limits have been reached, check for release type
		if (i == v2.versionArr.length && i == versionArr.length) {
			int compareResult = releaseType.compareTo(v2.releaseType);
			if(compareResult < 0) return -1;
			else if (compareResult > 0) return 1;
			else return 0;
		}
		// if only one version array's limit has been reached, the other version
		// may be newer
		else {
			int j = i;
			while (j < versionArr.length) {
				if (versionArr[j] != 0) return 1;
				j++;
			}
			j = i;
			while (j < v2.versionArr.length) {
				if (v2.versionArr[j] != 0) return -1;
				j++;
			}
			// If there additional array elements are 0's only, the version numbers are
			// the same, check for release type
			int compareResult = releaseType.compareTo(v2.releaseType);
			if(compareResult < 0) return -1;
			else if (compareResult > 0) return 1;
			else return 0;
		}
	}

	/**
	 * Checks whether version is significantly newer than version2
	 * 
	 * @param version2
	 * @param i
	 *            0-based significance
	 * @return True if any of the version numbers with index equal or smaller i is bigger than the version number of version2 with the same index
	 */
	public boolean isSignificantlyNewerThan(PluginVersion version2, int i) {
		int j = 0;
		while (j <= i && j < versionArr.length && j < version2.versionArr.length) {
			if (versionArr[j] > version2.versionArr[j]) return true;
			j++;
		}
		while (j <= i && j < versionArr.length) {
			if (versionArr[j] != 0) return true;
			j++;
		}
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((releaseType == null) ? 0 : releaseType.hashCode());
		boolean nonZeroFound = false;
		for (int i = versionArr.length - 1; i >= 0; i--) {
			if (versionArr[i] != 0) nonZeroFound = true;
			if (nonZeroFound) result = prime * result + versionArr[i];
		}
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		PluginVersion other = (PluginVersion) obj;
		if (this.compareTo(other) != 0) return false;
		return true;
	}

}
