/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.importer;

import com.evilmidget38.UUIDFetcher;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;

public abstract class Importer
implements Runnable {
    public static boolean debug = false;
    protected final Database db;
    protected final File pluginsFolder;
    private final Runnable runnable;
    private final HashMap<String, UUID> knownUUIDs;

    protected Importer(Database db, File pluginsFolder, Runnable runnable) {
        this.db = db;
        this.pluginsFolder = pluginsFolder;
        this.runnable = runnable;
        this.knownUUIDs = new HashMap(1024);
    }

    @Override
    public abstract void run();

    protected void finished() {
        this.runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<UUID, EntityType> getEntities() {
        Server server = Bukkit.getServer();
        synchronized (server) {
            HashMap<UUID, EntityType> entities = new HashMap<UUID, EntityType>(2048);
            for (World world : Bukkit.getServer().getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    entities.put(entity.getUniqueId(), entity.getType());
                }
            }
            return entities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUser(String name) {
        UUID id;
        if (this.knownUUIDs.containsKey(name)) {
            UUID known = this.knownUUIDs.get(name);
            if (known != null) {
                return User.getInstance(known);
            }
            return null;
        }
        Server server = Bukkit.getServer();
        synchronized (server) {
            id = Bukkit.getServer().getOfflinePlayer(name).getUniqueId();
        }
        if (id != null) {
            this.knownUUIDs.put(name, id);
            return User.getInstance(id);
        }
        UUIDFetcher fetcher = new UUIDFetcher(Collections.singletonList(name));
        try {
            id = (UUID)fetcher.call().get(name);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.knownUUIDs.put(name, id);
        if (id != null) {
            return User.getInstance(id);
        }
        return null;
    }

    protected Map<String, UUID> getUsers(List<String> names) throws Exception {
        UUIDFetcher fetcher = new UUIDFetcher(names);
        return fetcher.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemFrame getItemFrame(String worldName, int x, int y, int z) {
        Server server = Bukkit.getServer();
        synchronized (server) {
            World world = Bukkit.getServer().getWorld(worldName);
            if (world == null) {
                return null;
            }
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            for (Entity entity : loc.getChunk().getEntities()) {
                if (!(entity instanceof ItemFrame) || entity.getLocation().getBlockX() != loc.getBlockX() || entity.getLocation().getBlockY() != loc.getBlockY() || entity.getLocation().getBlockZ() != loc.getBlockZ()) continue;
                return (ItemFrame)entity;
            }
            return null;
        }
    }
}

