/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.importer;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.importer.Importer;
import de.pheasn.blockown.importer.ImporterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

public class BlockOwn1
extends Importer {
    public BlockOwn1(Database db, File pluginsFolder, Runnable runnable) {
        super(db, pluginsFolder, runnable);
    }

    @Override
    public void run() {
        String url;
        block17: {
            File configFile = new File(this.pluginsFolder, "BlockOwn1/config.yml");
            if (!configFile.exists()) {
                throw new ImporterException("Old config.yml not found!");
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            if (!config.getString("Settings-Version").equalsIgnoreCase("1.3.7")) {
                throw new ImporterException("Old config must have version 1.3.7");
            }
            try {
                if (config.getBoolean("ServerSettings.MySQL.enable")) {
                    String type = config.getString("ServerSettings.MySQL.type");
                    if (type.equalsIgnoreCase("network")) {
                        Class.forName("com.mysql.jdbc.Driver");
                        String host = config.getString("ServerSettings.MySQL.host");
                        int port = config.getInt("ServerSettings.MySQL.port");
                        String databaseName = config.getString("ServerSettings.MySQL.database");
                        String username = config.getString("ServerSettings.MySQL.user");
                        String password = config.getString("ServerSettings.MySQL.password");
                        url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user=" + username + "&password=" + password + "&autoReconnect=true";
                    } else {
                        Class.forName("org.sqlite.JDBC");
                        url = "jdbc:sqlite:" + this.pluginsFolder.getPath() + "/BlockOwn1/data.db";
                    }
                    break block17;
                }
                this.importClassic(this.db);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new ImporterException("driver class not found");
            }
        }
        try {
            Map<String, UUID> users;
            Connection con = DriverManager.getConnection(url);
            Statement stmnt = con.createStatement();
            ResultSet nameSet = stmnt.executeQuery("SELECT playername FROM player;");
            LinkedList<String> names = new LinkedList<String>();
            while (nameSet.next()) {
                names.add(nameSet.getString("playername"));
            }
            stmnt.close();
            try {
                users = this.getUsers(names);
            }
            catch (Exception e) {
                System.out.println("Error while fetching UUIDs");
                return;
            }
            stmnt = con.createStatement();
            ResultSet blockSet = stmnt.executeQuery("SELECT * FROM block INNER JOIN player ON block.ownerid=player.playerid;");
            int count = 0;
            int skipped = 0;
            while (blockSet.next()) {
                Ownable ownable;
                ++count;
                boolean isBlock = blockSet.getBoolean("isblock");
                String worldName = blockSet.getString("world");
                int x = blockSet.getInt("x");
                int y = blockSet.getInt("y");
                int z = blockSet.getInt("z");
                UUID id = users.get(blockSet.getString("playername"));
                if (id == null) {
                    ++skipped;
                    continue;
                }
                User owner = User.getInstance(id);
                if (!isBlock) {
                    ItemFrame iF = this.getItemFrame(worldName, x, y, z);
                    if (iF == null) {
                        ++skipped;
                        continue;
                    }
                    ownable = OwnedEntity.newInstance((Entity)iF);
                } else {
                    ownable = OwnedBlock.newInstance(worldName, x, y, z);
                }
                if (!this.db.getOwner(ownable).isNobody()) continue;
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(ownable, owner);
                this.db.enqueue(databaseAction);
            }
            System.out.println("Import skipped " + skipped + " of " + count + " entries.");
            stmnt.close();
            con.close();
            this.finished();
        }
        catch (SQLException e) {
            throw new ImporterException(e.getMessage());
        }
    }

    private void importClassic(Database db) throws ImporterException {
        File file = new File(this.pluginsFolder, "BlockOwn1/blocks.dat");
        if (!file.exists()) {
            throw new ImporterException("Flat file database doesn't exist");
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int count = 0;
            int skipped = 0;
            while ((line = br.readLine()) != null) {
                Ownable ownable;
                ++count;
                String[] owningDiv = line.split(":");
                String worldName = owningDiv[0];
                String[] blockCoordinates = owningDiv[1].split("#");
                String playerName = owningDiv[2];
                boolean isBlock = owningDiv[3].equalsIgnoreCase("1");
                User owner = this.getUser(playerName);
                if (owner == null) {
                    ++skipped;
                    continue;
                }
                int x = Integer.parseInt(blockCoordinates[0]);
                int y = Integer.parseInt(blockCoordinates[1]);
                int z = Integer.parseInt(blockCoordinates[2]);
                if (isBlock) {
                    ownable = OwnedBlock.newInstance(worldName, x, y, z);
                } else {
                    ItemFrame iF = this.getItemFrame(worldName, x, y, z);
                    if (iF == null) {
                        ++skipped;
                        continue;
                    }
                    ownable = OwnedEntity.newInstance((Entity)iF);
                }
                if (!db.getOwner(ownable).isNobody()) continue;
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(ownable, owner);
                db.enqueue(databaseAction);
            }
            System.out.println("Import skipped " + skipped + " of " + count + " entries.");
            br.close();
            this.finished();
        }
        catch (IOException e) {
            throw new ImporterException(e.getMessage());
        }
    }
}

