/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.event.Listener;
import de.pheasn.blockown.protection.ProtectAction;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class L_PlayerInteract
extends Listener {
    public L_PlayerInteract(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBlockInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() == org.bukkit.Material.AIR) {
            return;
        }
        if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get().booleanValue() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getClickedBlock().getWorld())) {
            return;
        }
        User user = User.getInstance(event.getPlayer().getUniqueId());
        if (this.plugin.isIgnoring(user)) {
            return;
        }
        OwnedBlock ownedBlock = OwnedBlock.newInstance(block);
        try {
            if (this.invalid(ownedBlock, user)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerEntityInteract(PlayerInteractEntityEvent event) {
        if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getRightClicked().getWorld())) {
            return;
        }
        User user = User.getInstance(event.getPlayer().getUniqueId());
        if (this.plugin.isIgnoring(user)) {
            return;
        }
        OwnedEntity entity = OwnedEntity.newInstance(event.getRightClicked());
        try {
            if (this.invalid(entity, user)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            User user = User.getInstance(player.getUniqueId());
            if (this.plugin.isIgnoring(user)) {
                return;
            }
            OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
            try {
                if (this.invalid(entity, user)) {
                    event.setCancelled(true);
                }
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBreakHanging(HangingBreakByEntityEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getRemover() instanceof Player) {
            Player player = (Player)event.getRemover();
            User user = User.getInstance(player.getUniqueId());
            if (this.plugin.isIgnoring(user)) {
                return;
            }
            OwnedEntity entity = OwnedEntity.newInstance((Entity)event.getEntity());
            try {
                if (this.invalid(entity, user)) {
                    event.setCancelled(true);
                }
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
            }
        }
    }

    private boolean invalid(Ownable ownable, User user) throws InvalidWorldException {
        User owner = this.plugin.getOwningDatabase().getOwner(ownable);
        if (owner.isNobody()) {
            return false;
        }
        return !owner.equals(user) && !user.hasAccess(ownable);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChooseEntity(PlayerInteractEntityEvent event) {
        Material material;
        if (!this.plugin.isEnabledInWorld(event.getRightClicked().getWorld())) {
            return;
        }
        User user = User.getInstance(event.getPlayer().getUniqueId());
        WaitType waitType = this.plugin.getWaiting(user);
        if (waitType == null) {
            return;
        }
        event.setCancelled(true);
        OwnedEntity entity = OwnedEntity.newInstance(event.getRightClicked());
        try {
            material = entity.getMaterial();
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
            return;
        }
        if (!this.plugin.isOwnEnabled(material)) {
            return;
        }
        User owner = this.plugin.getOwningDatabase().getOwner(entity);
        Player player = event.getPlayer();
        switch (waitType) {
            case SHOW_OWNER_ENTITY: {
                if (owner.isNobody()) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_ENTITY_UNOWNED);
                    break;
                }
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_ENTITY_FOUND, owner.getName());
                break;
            }
            case OWN_ENTITY: {
                if (owner.isNobody()) {
                    DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, user);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_ENTITYSUCCESS, material.getName());
                    break;
                }
                if (owner.equals(user)) break;
                this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
                break;
            }
            case UNOWN_ENTITY: {
                if (owner.equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                    DatabaseAction databaseAction = DatabaseAction.newUnownInstance(entity);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                    this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_ENTITYSUCCESS, material.getName());
                    break;
                }
                this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                break;
            }
            case PROTECT_ENTITY: {
                ProtectAction protectAction = new ProtectAction.Builder(user).protect(material).build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                this.plugin.removeWaiting(user);
                break;
            }
            case UNPROTECT_ENTITY: {
                ProtectAction protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                this.plugin.removeWaiting(user);
                break;
            }
            case LOCK_ENTITY: {
                ProtectAction protectAction = new ProtectAction.Builder(user).lock(material).build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_LOCK_SUCCESS, material.getName());
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                this.plugin.removeWaiting(user);
                break;
            }
            case UNLOCK_ENTITY: {
                ProtectAction protectAction = new ProtectAction.Builder(user).unlock(material).build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNLOCK_SUCCESS, material.getName());
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                this.plugin.removeWaiting(user);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChooseBlock(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Material material;
            Block nativeBlock = event.getClickedBlock();
            if (!this.plugin.isEnabledInWorld(nativeBlock.getWorld())) {
                return;
            }
            User user = User.getInstance(event.getPlayer().getUniqueId());
            WaitType waitType = this.plugin.getWaiting(user);
            if (waitType == null) {
                return;
            }
            event.setCancelled(true);
            OwnedBlock block = OwnedBlock.newInstance(nativeBlock);
            try {
                material = block.getMaterial();
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
                return;
            }
            if (!this.plugin.isOwnEnabled(material)) {
                return;
            }
            User owner = this.plugin.getOwningDatabase().getOwner(block);
            Player player = event.getPlayer();
            switch (waitType) {
                case SHOW_OWNER_BLOCK: {
                    if (owner.isNobody()) {
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED);
                        break;
                    }
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName());
                    break;
                }
                case OWN_BLOCK: {
                    if (owner.isNobody()) {
                        DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, user);
                        this.plugin.getOwningDatabase().enqueue(databaseAction);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_BLOCKSUCCESS, material.getName());
                        break;
                    }
                    if (owner.equals(user)) break;
                    this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
                    break;
                }
                case UNOWN_BLOCK: {
                    if (owner.equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                        DatabaseAction databaseAction = DatabaseAction.newUnownInstance(block);
                        this.plugin.getOwningDatabase().enqueue(databaseAction);
                        this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_BLOCKSUCCESS, material.getName());
                        break;
                    }
                    this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                    break;
                }
                case PROTECT_BLOCK: {
                    ProtectAction protectAction = new ProtectAction.Builder(user).protect(material).build();
                    this.plugin.getProtection().enqueue(protectAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    this.plugin.removeWaiting(user);
                    break;
                }
                case UNPROTECT_BLOCK: {
                    ProtectAction protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                    this.plugin.getProtection().enqueue(protectAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    this.plugin.removeWaiting(user);
                    break;
                }
                case LOCK_BLOCK: {
                    ProtectAction protectAction = new ProtectAction.Builder(user).lock(material).build();
                    this.plugin.getProtection().enqueue(protectAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_LOCK_SUCCESS, material.getName());
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    this.plugin.removeWaiting(user);
                    break;
                }
                case UNLOCK_BLOCK: {
                    ProtectAction protectAction = new ProtectAction.Builder(user).unlock(material).build();
                    this.plugin.getProtection().enqueue(protectAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNLOCK_SUCCESS, material.getName());
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    this.plugin.removeWaiting(user);
                    break;
                }
            }
        }
    }
}

