/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.event.Listener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;

public class L_EnvironmentDamage
extends Listener {
    private static final Set<EntityDamageEvent.DamageCause> ENVIRONMENT_DAMAGES;
    private static final Set<BlockFace> FIRE_RELEVANT_BLOCK_FACES;

    public L_EnvironmentDamage(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
        try {
            if (this.invalidAccess(block)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
        }
    }

    private void extinguishSurroundingFires(Block block) {
        for (BlockFace face : FIRE_RELEVANT_BLOCK_FACES) {
            Block relative = block.getRelative(face);
            if (relative.getType() != Material.FIRE) continue;
            relative.setType(Material.AIR);
        }
    }

    public void onBlockIgnite(BlockIgniteEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
        try {
            if (this.invalidAccess(block)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
        }
    }

    public void onLightningStrike(LightningStrikeEvent event) {
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!this.isProtectedDamageCause(event.getCause())) {
            return;
        }
        OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
        try {
            if (this.invalidAccess(entity)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWaterBreak(BlockFromToEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = OwnedBlock.newInstance(event.getToBlock());
        try {
            if (this.invalidAccess(block)) {
                event.setCancelled(true);
            }
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        for (Block nativeBlock : event.getBlocks()) {
            OwnedBlock block = OwnedBlock.newInstance(nativeBlock);
            try {
                if (!this.invalidAccess(block)) continue;
                event.setCancelled(true);
                return;
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExploded(EntityExplodeEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            OwnedBlock block = OwnedBlock.newInstance((Block)iterator.next());
            try {
                if (!this.invalidAccess(block)) continue;
                iterator.remove();
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTrample(EntityChangeBlockEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof HumanEntity)) {
            OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
            try {
                if (this.invalidAccess(block)) {
                    event.setCancelled(true);
                }
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_ENVDAM", e);
            }
        }
    }

    private boolean invalidAccess(Ownable ownable) throws InvalidWorldException {
        User owner;
        if (this.plugin.isOwnEnabled(ownable.getMaterial()) && !(owner = this.plugin.getOwningDatabase().getOwner(ownable)).isNobody() && (this.plugin.getProtection().isProtected(owner, ownable.getMaterial()) || this.plugin.getProtection().isLocked(owner, ownable.getMaterial()))) {
            return true;
        }
        if (ownable instanceof OwnedBlock) {
            Block block = ((OwnedBlock)ownable).getBlock();
            for (Block attachedBlock : this.getAttachedBlocks(block)) {
                OwnedBlock attachedOwned = OwnedBlock.newInstance(attachedBlock);
                User attachedOwner = this.plugin.getOwningDatabase().getOwner(attachedOwned);
                if (attachedOwner.isNobody() || !this.plugin.getProtection().isProtected(attachedOwner, attachedOwned.getMaterial()) && !this.plugin.getProtection().isLocked(attachedOwner, attachedOwned.getMaterial())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProtectedDamageCause(EntityDamageEvent.DamageCause cause) {
        return ENVIRONMENT_DAMAGES.contains(cause);
    }

    static {
        HashSet<EntityDamageEvent.DamageCause> envDmg = new HashSet<EntityDamageEvent.DamageCause>(8, 1.0f);
        envDmg.addAll(Arrays.asList(EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.FALLING_BLOCK, EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.LIGHTNING, EntityDamageEvent.DamageCause.PROJECTILE));
        ENVIRONMENT_DAMAGES = Collections.unmodifiableSet(envDmg);
        HashSet<BlockFace> blockFaces = new HashSet<BlockFace>(6, 1.0f);
        blockFaces.addAll(Arrays.asList(BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST, BlockFace.DOWN));
        FIRE_RELEVANT_BLOCK_FACES = Collections.unmodifiableSet(blockFaces);
    }
}

