/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.event.Listener;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class L_BlockPlace
extends Listener {
    public L_BlockPlace(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld()) && player.hasPermission(Permission.OWN_PLACE.toString())) {
            User user = User.getInstance(player.getUniqueId());
            if (!this.plugin.isOwning(user)) {
                return;
            }
            OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
            try {
                if (this.plugin.isOwnEnabled(block.getMaterial())) {
                    DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, user);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                }
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isEnabledInWorld(event.getBlock().getWorld()) && event.getPlayer().hasPermission(Permission.OWN_PLACE.toString())) {
            User owner = User.getInstance(event.getPlayer().getUniqueId());
            if (!this.plugin.isOwning(owner)) {
                return;
            }
            OwnedEntity entity = OwnedEntity.newInstance((Entity)event.getEntity());
            try {
                if (this.plugin.isOwnEnabled(entity.getMaterial())) {
                    DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, owner);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                }
            }
            catch (InvalidWorldException e) {
                this.plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld()) && player.hasPermission(Permission.OWN_PLACE.toString())) {
            User user = User.getInstance(player.getUniqueId());
            if (!this.plugin.isOwning(user)) {
                return;
            }
            for (BlockState state : event.getReplacedBlockStates()) {
                OwnedBlock block = OwnedBlock.newInstance(state.getBlock());
                try {
                    if (!this.plugin.isOwnEnabled(block.getMaterial())) continue;
                    DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, user);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                }
                catch (InvalidWorldException e) {
                    this.plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.isEnabledInWorld(event.getWorld())) {
            OwnedBlock block = OwnedBlock.newInstance(event.getLocation().getBlock());
            User owner = this.plugin.getOwningDatabase().getOwner(block);
            if (owner.isNobody()) {
                return;
            }
            for (BlockState state : event.getBlocks()) {
                block = OwnedBlock.newInstance(state.getBlock());
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, owner);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        Material m;
        if (this.plugin.isEnabledInWorld(event.getBlock().getWorld()) && ((m = event.getNewState().getType()) == Material.SUGAR_CANE_BLOCK || m == Material.CACTUS)) {
            Block lowerBlock = event.getBlock().getRelative(BlockFace.DOWN);
            OwnedBlock lowerOwned = OwnedBlock.newInstance(lowerBlock);
            User owner = this.plugin.getOwningDatabase().getOwner(lowerOwned);
            if (!owner.isNobody()) {
                OwnedBlock owned = OwnedBlock.newInstance(event.getBlock());
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(owned, owner);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlaceNearChest(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld())) {
            if (event.getBlock().getType() != Material.CHEST) {
                return;
            }
            User user = User.getInstance(event.getPlayer().getUniqueId());
            Block blockRight = event.getBlock().getRelative(1, 0, 0);
            Block blockLeft = event.getBlock().getRelative(-1, 0, 0);
            Block blockFront = event.getBlock().getRelative(0, 0, 1);
            Block blockBack = event.getBlock().getRelative(0, 0, -1);
            if (blockLeft.getType() == Material.CHEST && this.invalidPlacement(blockLeft, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockRight.getType() == Material.CHEST && this.invalidPlacement(blockRight, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockFront.getType() == Material.CHEST && this.invalidPlacement(blockFront, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockBack.getType() == Material.CHEST && this.invalidPlacement(blockBack, user)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    private boolean invalidPlacement(Block nativeBlock, User user) {
        OwnedBlock block = OwnedBlock.newInstance(nativeBlock);
        User owner = this.plugin.getOwningDatabase().getOwner(block);
        if (owner.isNobody()) {
            return false;
        }
        if (owner.equals(user)) {
            return false;
        }
        try {
            boolean result = this.plugin.getProtection().isProtected(owner, block.getMaterial()) || this.plugin.getProtection().isLocked(owner, block.getMaterial());
            return result;
        }
        catch (InvalidWorldException e) {
            this.plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
            return true;
        }
    }
}

