/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CachedDatabase;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;

public class SqliteDatabase
extends CachedDatabase {
    private static final String FILENAME = "world.db";
    private final File pluginDataFolder;

    public SqliteDatabase(Output output, File pluginFolder) throws SQLException, ClassNotFoundException {
        super(output, pluginFolder);
        this.pluginDataFolder = pluginFolder.getAbsoluteFile();
        Class.forName("org.sqlite.JDBC");
        this.connection = this.connect();
        this.createTables();
    }

    private Connection connect() throws SQLException {
        File file = new File(this.pluginDataFolder, FILENAME);
        String url = "jdbc:sqlite:" + file.getPath();
        return DriverManager.getConnection(url);
    }

    @Override
    String[] generateCreateTableQueries() {
        String[] queries = new String[]{this.generateCreateBlockTableQuery(), this.generateCreateEntityTableQuery()};
        return queries;
    }

    private String generateCreateBlockTableQuery() {
        return "CREATE TABLE IF NOT EXISTS block_table (world VARCHAR(50), x INT, y INT, z INT, player_id CHAR(36) NOT NULL, PRIMARY KEY (world, x, y, z));";
    }

    private String generateCreateEntityTableQuery() {
        return "CREATE TABLE IF NOT EXISTS entity_table (world VARCHAR(50) NOT NULL, entity_id CHAR(36), player_id CHAR(36) NOT NULL, PRIMARY KEY (entity_id));";
    }

    @Override
    String generateGetOwnerQuery(Ownable ownable) {
        if (ownable instanceof OwnedBlock) {
            return this.generateGetOwnerQuery((OwnedBlock)ownable);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateGetOwnerQuery((OwnedEntity)ownable);
        }
        throw new IllegalArgumentException("Unknown Ownable implementation");
    }

    private String generateGetOwnerQuery(OwnedBlock block) {
        return "SELECT player_id FROM block_table WHERE world='" + block.getWorldName() + "' AND " + "x" + "=" + block.getX() + " AND " + "y" + "=" + block.getY() + " AND " + "z" + "=" + block.getZ() + ";";
    }

    private String generateGetOwnerQuery(OwnedEntity entity) {
        return "SELECT player_id FROM entity_table WHERE world='" + entity.getWorldName() + "' AND " + "entity_id" + "='" + entity.getUniqueId().toString() + "';";
    }

    @Override
    String generateSetOwnerQuery(DatabaseAction databaseAction) {
        Ownable ownable = databaseAction.getOwnable();
        if (ownable instanceof OwnedBlock) {
            return this.generateSetBlockOwnerQuery(databaseAction);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateSetEntityOwnerQuery(databaseAction);
        }
        throw new IllegalArgumentException("Unknown Ownable implementation");
    }

    private String generateSetBlockOwnerQuery(DatabaseAction databaseAction) {
        OwnedBlock block = (OwnedBlock)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        return "INSERT OR REPLACE INTO block_table(world, x, y, z, player_id) VALUES('" + worldName + "', '" + x + "', '" + y + "', '" + z + "', '" + playerId + "');";
    }

    private String generateSetEntityOwnerQuery(DatabaseAction databaseAction) {
        OwnedEntity entity = (OwnedEntity)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        UUID entityId = entity.getUniqueId();
        return "INSERT OR REPLACE INTO entity_table(world, entity_id, player_id) VALUES('" + worldName + "', '" + entityId.toString() + "', '" + playerId + "');";
    }

    @Override
    String generateDeleteOwnerQuery(Ownable ownable) {
        if (ownable instanceof OwnedBlock) {
            return this.generateDeleteOwnerQuery((OwnedBlock)ownable);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateDeleteOwnerQuery((OwnedEntity)ownable);
        }
        throw new IllegalArgumentException("Unknown Ownable implementation");
    }

    private String generateDeleteOwnerQuery(OwnedEntity entity) {
        return "DELETE FROM entity_table WHERE world='" + entity.getWorldName() + "' AND " + "entity_id" + "='" + entity.getUniqueId().toString() + "';";
    }

    private String generateDeleteOwnerQuery(OwnedBlock block) {
        return "DELETE FROM block_table WHERE world='" + block.getWorldName() + "' AND " + "x" + "=" + block.getX() + " AND " + "y" + "=" + block.getY() + " AND " + "z" + "=" + block.getZ() + ";";
    }

    @Override
    String[] generateDropUserQueries(User user) {
        String[] queries = new String[]{this.generateDropUserBlocksQuery(user), this.generateDropUserEntitiesQuery(user)};
        return queries;
    }

    private String generateDropUserBlocksQuery(User user) {
        return "DELETE FROM block_table WHERE player_id='" + user.getId().toString() + "';";
    }

    private String generateDropUserEntitiesQuery(User user) {
        return "DELETE FROM entity_table WHERE player_id='" + user.getId().toString() + "';";
    }
}

