/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CachedDatabase;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;

public class MySqlDatabase
extends CachedDatabase {
    private final String DATABASE_URL;

    public MySqlDatabase(Output output, File pluginFolder, String host, int port, String databaseName, String username, String password) throws SQLException, ClassNotFoundException {
        super(output, pluginFolder);
        Class.forName("com.mysql.jdbc.Driver");
        this.DATABASE_URL = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?autoReconnect=true";
        this.connection = this.connect(username, password);
        this.createTables();
    }

    public MySqlDatabase(Output output, File pluginFolder, String host, int port, String databaseName, String username) throws SQLException, ClassNotFoundException {
        super(output, pluginFolder);
        Class.forName("com.mysql.jdbc.Driver");
        this.DATABASE_URL = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?autoReconnect=true";
        this.connection = this.connect(username, null);
        this.createTables();
    }

    private Connection connect(String user, String password) throws SQLException {
        return DriverManager.getConnection(this.DATABASE_URL, user, password);
    }

    @Override
    String[] generateCreateTableQueries() {
        String[] queries = new String[]{this.generateCreateBlockTableQuery(), this.generateCreateEntityTableQuery()};
        return queries;
    }

    private String generateCreateBlockTableQuery() {
        return "CREATE TABLE IF NOT EXISTS block_table (" + System.lineSeparator() + "world" + " VARCHAR(50), " + System.lineSeparator() + "x" + " INT, " + System.lineSeparator() + "y" + " INT, " + System.lineSeparator() + "z" + " INT, " + System.lineSeparator() + "player_id" + " CHAR(36) NOT NULL, " + System.lineSeparator() + "PRIMARY KEY (" + System.lineSeparator() + "world" + ", " + System.lineSeparator() + "x" + ", " + System.lineSeparator() + "y" + ", " + System.lineSeparator() + "z" + "));";
    }

    private String generateCreateEntityTableQuery() {
        return "CREATE TABLE IF NOT EXISTS entity_table (world VARCHAR(50) NOT NULL, entity_id CHAR(36), player_id CHAR(36) NOT NULL, PRIMARY KEY (entity_id));";
    }

    @Override
    String generateGetOwnerQuery(Ownable ownable) {
        if (ownable instanceof OwnedBlock) {
            return this.generateGetOwnerQuery((OwnedBlock)ownable);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateGetOwnerQuery((OwnedEntity)ownable);
        }
        throw new IllegalArgumentException("Unknown ownable implementation");
    }

    private String generateGetOwnerQuery(OwnedBlock block) {
        return "SELECT player_id FROM block_table WHERE world='" + block.getWorldName() + "' AND " + "x" + "=" + block.getX() + " AND " + "y" + "=" + block.getY() + " AND " + "z" + "=" + block.getZ() + ";";
    }

    private String generateGetOwnerQuery(OwnedEntity entity) {
        return "SELECT player_id FROM entity_table WHERE world='" + entity.getWorldName() + "' AND " + "entity_id" + "='" + entity.getUniqueId().toString() + "';";
    }

    @Override
    String generateSetOwnerQuery(DatabaseAction databaseAction) {
        Ownable ownable = databaseAction.getOwnable();
        if (ownable instanceof OwnedBlock) {
            return this.generateSetBlockOwnerQuery(databaseAction);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateSetEntityOwnerQuery(databaseAction);
        }
        throw new IllegalArgumentException("Unknown ownable implementation");
    }

    private String generateSetBlockOwnerQuery(DatabaseAction databaseAction) {
        OwnedBlock block = (OwnedBlock)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        return "INSERT INTO block_table(world, x, y, z, player_id) VALUES('" + worldName + "', '" + x + "', '" + y + "', '" + z + "', '" + playerId + "')" + " ON DUPLICATE KEY UPDATE " + "world" + "=" + "VALUES(" + "world" + "), " + "x" + "=" + "VALUES(" + "x" + "), " + "y" + "=" + "VALUES(" + "y" + "), " + "z" + "=" + "VALUES(" + "z" + "), " + "player_id" + "=" + "VALUES(" + "player_id" + ");";
    }

    private String generateSetEntityOwnerQuery(DatabaseAction databaseAction) {
        OwnedEntity entity = (OwnedEntity)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        UUID entityId = entity.getUniqueId();
        return "INSERT INTO entity_table(world, entity_id, player_id) VALUES('" + worldName + "', '" + entityId.toString() + "', '" + playerId + "') ON DUPLICATE KEY UPDATE " + "world" + "=" + "VALUES(" + "world" + "), " + "entity_id" + "=" + "VALUES(" + "entity_id" + "), " + "player_id" + "=" + "VALUES(" + "player_id" + ");";
    }

    @Override
    String generateDeleteOwnerQuery(Ownable ownable) {
        if (ownable instanceof OwnedBlock) {
            return this.generateDeleteOwnerQuery((OwnedBlock)ownable);
        }
        if (ownable instanceof OwnedEntity) {
            return this.generateDeleteOwnerQuery((OwnedEntity)ownable);
        }
        throw new IllegalArgumentException("Unknown Ownable implementation");
    }

    private String generateDeleteOwnerQuery(OwnedEntity entity) {
        String worldName = entity.getWorldName();
        return "DELETE FROM entity_table WHERE world='" + worldName + "' AND " + "entity_id" + "='" + entity.getUniqueId().toString() + "';";
    }

    private String generateDeleteOwnerQuery(OwnedBlock block) {
        String worldName = block.getWorldName();
        return "DELETE FROM block_table WHERE world='" + worldName + "' AND " + "x" + "=" + block.getX() + " AND " + "y" + "=" + block.getY() + " AND " + "z" + "=" + block.getZ() + ";";
    }

    @Override
    String[] generateDropUserQueries(User user) {
        String[] queries = new String[]{this.generateDropUserBlocksQuery(user), this.generateDropUserEntitiesQuery(user)};
        return queries;
    }

    private String generateDropUserBlocksQuery(User user) {
        return "DELETE FROM block_table WHERE player_id='" + user.getId().toString() + "';";
    }

    private String generateDropUserEntitiesQuery(User user) {
        return "DELETE FROM entity_table WHERE player_id='" + user.getId().toString() + "';";
    }
}

